<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class () extends Migration {
    public function up(): void
    {
        Schema::create('eb_events', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->foreignId('account_id');
            $table->string('short_description')->nullable();
            $table->string('description')->nullable();
            $table->boolean('is_featured')->default(false);
            $table->longText('content');
            $table->string('unique_id')->unique();
            $table->string('image')->nullable();
            $table->decimal('price')->nullable();
            $table->string('address');
            $table->foreignId('country_id')->nullable();
            $table->foreignId('state_id')->nullable();
            $table->foreignId('city_id')->nullable();
            $table->string('latitude', 25)->nullable();
            $table->string('longitude', 25)->nullable();
            $table->unsignedInteger('seats');
            $table->unsignedInteger('views')->default(0);
            $table->dateTime('started_at');
            $table->dateTime('ended_at')->nullable();
            $table->dateTime('booking_closed_at')->nullable();
            $table->foreignId('tax_id')->nullable();
            $table->string('status')->default('pending');
            $table->timestamps();
        });

        Schema::create('eb_events_translations', function (Blueprint $table) {
            $table->string('lang_code');
            $table->foreignId('eb_events_id');
            $table->string('name', 255)->nullable();
            $table->string('short_description')->nullable();
            $table->string('description')->nullable();
            $table->longText('content')->nullable();

            $table->primary(['lang_code', 'eb_events_id'], 'eb_events_translations_primary');
        });

        Schema::create('eb_event_speaker', function (Blueprint $table) {
            $table->foreignId('event_id');
            $table->foreignId('speaker_id');
            $table->string('title')->nullable();
            $table->string('subtitle')->nullable();
            $table->unsignedInteger('priority')->default(0);
            $table->dateTime('started_at')->nullable();
            $table->dateTime('ended_at')->nullable();
        });

        Schema::create('eb_event_attendee', function (Blueprint $table) {
            $table->foreignId('event_id');
            $table->foreignId('attendee_id');
            $table->string('hash')->unique();
            $table->dateTime('checked_in_at')->nullable();
        });

        Schema::create('eb_accounts', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->string('password');
            $table->string('avatar')->nullable();
            $table->string('phone')->nullable();
            $table->date('dob')->nullable();
            $table->string('type', 30)->default('attendee');
            $table->string('status', 30)->default('activated');
            $table->string('remember_token', 100)->nullable();
            $table->dateTime('confirmed_at')->nullable();
            $table->string('email_verify_token', 120)->nullable();
            $table->timestamps();
        });

        Schema::create('eb_account_password_resets', function (Blueprint $table) {
            $table->string('email')->index();
            $table->string('token')->index();
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('eb_orders', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique();
            $table->string('token')->unique()->nullable();
            $table->foreignId('event_id');
            $table->string('event_name')->nullable();
            $table->decimal('event_ticket_price')->nullable();
            $table->foreignId('account_id')->nullable();
            $table->foreignId('currency_id');
            $table->string('account_name')->nullable();
            $table->string('account_email')->nullable();
            $table->string('note')->nullable();
            $table->string('private_note')->nullable();
            $table->string('payment_id')->nullable();
            $table->decimal('price');
            $table->unsignedInteger('quantity');
            $table->decimal('subtotal');
            $table->decimal('total');
            $table->decimal('tax_amount')->default(0);
            $table->decimal('coupon_amount')->default(0);
            $table->string('coupon_code')->nullable();
            $table->string('status')->default('pending');
            $table->dateTime('completed_at')->nullable();
            $table->timestamps();
        });

        Schema::create('eb_tickets', function (Blueprint $table) {
            $table->id();
            $table->foreignId('order_id')->nullable();
            $table->string('code')->unique();
            $table->string('name')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('note')->nullable();
            $table->date('checked_in_at')->nullable();
            $table->string('status')->default('purchased');
            $table->timestamps();
        });

        Schema::create('eb_invoices', function (Blueprint $table) {
            $table->id();
            $table->morphs('reference');
            $table->string('code')->unique();
            $table->string('account_name')->nullable();
            $table->string('account_email')->nullable();
            $table->string('account_phone')->nullable();
            $table->string('company_name')->nullable();
            $table->string('company_logo')->nullable();
            $table->decimal('sub_total', 15);
            $table->decimal('amount', 15);
            $table->decimal('tax_amount', 15)->default(0);
            $table->decimal('discount_amount', 15)->default(0);
            $table->text('description')->nullable();
            $table->foreignId('payment_id')->nullable()->index();
            $table->string('status')->index()->default('pending');
            $table->timestamp('paid_at')->nullable();
            $table->timestamps();
        });

        Schema::create('eb_invoice_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_id');
            $table->morphs('reference');
            $table->string('name');
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->unsignedInteger('qty');
            $table->decimal('sub_total', 15)->nullable();
            $table->decimal('amount', 15)->nullable();
            $table->text('metadata')->nullable();
            $table->timestamps();
        });

        Schema::create('eb_currencies', function (Blueprint $table) {
            $table->id();
            $table->string('title', 60);
            $table->string('symbol', 10);
            $table->tinyInteger('is_prefix_symbol')->unsigned()->default(0);
            $table->tinyInteger('decimals')->unsigned()->default(0);
            $table->integer('order')->default(0)->unsigned();
            $table->tinyInteger('is_default')->default(0);
            $table->double('exchange_rate')->default(1);
            $table->timestamps();
        });

        Schema::create('eb_taxes', function (Blueprint $table): void {
            $table->id();
            $table->string('title')->nullable();
            $table->float('percentage', 8, 6)->nullable();
            $table->integer('priority')->nullable();
            $table->string('status', 60)->default('published');
            $table->timestamps();
        });

        Schema::create('eb_coupons', function (Blueprint $table): void {
            $table->id();
            $table->string('type');
            $table->string('code', 20)->unique();
            $table->decimal('value');
            $table->integer('quantity')->nullable();
            $table->unsignedInteger('total_used')->default(0);
            $table->dateTime('expires_date')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('eb_coupons');
        Schema::dropIfExists('eb_taxes');
        Schema::dropIfExists('eb_currencies');
        Schema::dropIfExists('eb_invoices');
        Schema::dropIfExists('eb_tickets');
        Schema::dropIfExists('eb_orders');
        Schema::dropIfExists('eb_accounts');
        Schema::dropIfExists('eb_events');
        Schema::dropIfExists('eb_events_translations');
    }
};
