<?php

use ArchiElite\EventsBooking\Enums\EventStatusEnum;
use ArchiElite\EventsBooking\Models\Event;
use Carbon\Carbon;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;
use Illuminate\Database\Eloquent\Builder;

if (! function_exists('get_events_booking_setting')) {
    function get_events_booking_setting($key, $default = null)
    {
        return setting('events_booking_' . $key, $default);
    }
}

if (! function_exists('render_price')) {
    function render_price(?float $price): string
    {
        if ($price == 0) {
            return __('Free');
        }

        return format_price($price);
    }
}

if (! function_exists('get_all_events')) {
    function get_all_events(int $paginate = 12): LengthAwarePaginator
    {
        return Event::query()
            ->with(['slugable', 'speakers.slugable'])
            ->where(function (Builder $query) {
                $query
                    ->whereNull('ended_at')
                    ->orWhere('ended_at', '>=', Carbon::now());
            })
            ->where('status', EventStatusEnum::APPROVED)
            ->orderBy('started_at')
            ->paginate($paginate);
    }
}
