<x-core::card.body class="p-0">
    <div class="list-search-data">
        <div class="list-group list-group-flush overflow-auto" style="max-height: 25rem;">
            @if (!$events->isEmpty())
                @foreach ($events as $event)
                    <a
                        href="#"
                        @class(['list-group-item list-group-item-action', 'selectable-item' => false])
                        data-bb-toggle="event-choose-item"
                        data-bb-url="{{ route('events-booking.ajax.choose-event', ['id' => $event->getKey()]) }}"
                    >
                        <div class="row align-items-center">
                            <div class="col-auto">
                                <span class="avatar" style="background-image: url('{{ RvMedia::getImageUrl($event->image, 'thumb', false, RvMedia::getDefaultImage()) }}')"></span>
                            </div>
                            <div class="col text-truncate">
                                <h4 class="text-body d-block mb-0">{{ $event->name }}</h4>
                            </div>
                        </div>
                    </a>
                @endforeach
            @else
                <div class="p-3">
                    <p class="text-muted my-0">{{ __('plugins/events-booking::events-booking.event.no_results') }}</p>
                </div>
            @endif
        </div>
    </div>
</x-core::card.body>
