<div class="table-wrapper">
    <x-core::card class="border-0">
        <x-core::card.header>
            <div class="w-100 justify-content-between d-flex flex-wrap align-items-center gap-1">
                <div class="btn-list">
                    <div class="table-search-input">
                        <label><input type="search" class="form-control input-sm" placeholder="{{ trans('core/table::table.search') }}"></label>
                    </div>
                </div>

                <div class="d-flex align-items-center gap-1">
                    @foreach($table->getButtons() as $button)
                        @if (Arr::get($button, 'extend') === 'collection')
                            <div class="dropdown d-inline-block">
                                <button class="btn buttons-collection dropdown-toggle {{ $button['className'] }}" data-bs-toggle="dropdown" tabindex="0" aria-controls="{{ $table->getOption('id') }}" type="button" aria-haspopup="dialog" aria-expanded="false">
                                    {!! $button['text'] !!}
                                </button>
                                <div class="dropdown-menu">
                                    @foreach($button['buttons'] as $buttonItem)
                                        <button class="dropdown-item {{ $buttonItem['className'] }}">
                                            {!! $buttonItem['text'] !!}
                                        </button>
                                    @endforeach
                                </div>
                            </div>
                        @else
                            <button class="btn {{ $button['className'] }}" tabindex="0" aria-controls="{{ $table->getOption('id') }}" type="button" aria-haspopup="dialog" aria-expanded="false">
                                {!! $button['text'] !!}
                            </button>
                        @endif
                    @endforeach

                    @foreach($table->getDefaultButtons() as $defaultButton)
                        @if (is_string($defaultButton))
                            @switch($defaultButton)
                                @case('reload')
                                    <x-core::button
                                        type="button"
                                        data-bb-toggle="dt-buttons"
                                        data-bb-target=".buttons-reload"
                                        tabindex="0"
                                        aria-controls="{{ $table->getOption('id') }}"
                                        icon="ti ti-refresh"
                                    >
                                        {{ trans('core/base::tables.reload') }}
                                    </x-core::button>
                                    @break
                                @case('export')
                                    <div class="dropdown">
                                        <button title="{{ trans('core/base::tables.export') }}" class="btn buttons-collection dropdown-toggle buttons-export" data-bs-toggle="dropdown" tabindex="0" aria-controls="{{ $table->getOption('id') }}" type="button" aria-haspopup="dialog" aria-expanded="false">
                                            <span>
                                                <x-core::icon name="ti ti-download" /> {{ trans('core/base::tables.export') }}
                                            </span>
                                        </button>
                                        <div class="dropdown-menu">
                                            <button class="dropdown-item" data-bb-toggle="dt-exports" data-bb-target="csv" aria-controls="{{ $table->getOption('id') }}">
                                                <span>
                                                    <x-core::icon name="ti ti-file-type-csv" /> {{ trans('core/base::tables.csv') }}
                                                </span>
                                            </button>
                                            <button class="dropdown-item" data-bb-toggle="dt-exports" data-bb-target="excel" aria-controls="{{ $table->getOption('id') }}">
                                                <span>
                                                    <x-core::icon name="ti ti-file-type-xls" /> {{ trans('core/base::tables.excel') }}
                                                </span>
                                            </button>
                                        </div>
                                    </div>
                                    @break
                                @case('visibility')
                                    @break(! Auth::user() instanceof \Botble\ACL\Models\User || ! AdminHelper::isInAdmin(true))

                                    <div class="dropdown" data-bb-toggle="dt-columns-visibility-dropdown" aria-controls="{{ $table->getOption('id') }}">
                                        <button title="{{ trans('core/base::tables.toggle_columns') }}" class="btn buttons-collection dropdown-toggle buttons-visibility" data-bs-toggle="dropdown" data-bs-auto-close="outside" tabindex="0" aria-controls="{{ $table->getOption('id') }}" type="button" aria-haspopup="dialog" aria-expanded="false">
                                            <span>
                                                <x-core::icon name="ti ti-columns-3" />
                                            </span>
                                        </button>

                                        <div class="dropdown-menu p-2">
                                            <x-core::form :url="route('table.update-columns-visibility')" method="PUT" data-bb-toggle="dt-columns-visibility">
                                                <input type="hidden" name="table" value="{{ $table::class }}" />

                                                @foreach($table->getColumns() as $column)
                                                    @php /** @var \Botble\Table\Columns\Column $column */ @endphp

                                                    @continue(! $column instanceof \Botble\Table\Columns\Column || Str::contains($column->className, 'no-column-visibility') || in_array($column->name, $table->getDefaultVisibleColumns(), true))

                                                    {{ Form::onOffCheckbox("columns_visibility[{$column->name}]", $table->determineIfColumnIsVisible($column), ['label' => $column->titleAttr ?: $column->title, 'data-bb-toggle' => 'dt-columns-visibility-toggle']) }}
                                                @endforeach
                                            </x-core::form>
                                        </div>
                                    </div>
                                    @break
                            @endswitch
                        @endif
                    @endforeach
                </div>
            </div>
        </x-core::card.header>

        <div class="card-table">
            <div class="table-responsive">
                {!! $dataTable->table(compact('id', 'class'), false) !!}
            </div>
        </div>
    </x-core::card>
</div>

@push('footer')
    {!! $dataTable->scripts() !!}
@endpush
