<div class="bb-account-page card crop-avatar">
    <div class="container">
        <div class="customer-body">
            <div class="row body-border">
                <div class="col-md-3 bb-account-sidebar-wrapper">
                    <div class="bb-profile-sidebar">
                        <div class="bb-profile-user-menu">
                            <div class="bb-account-sidebar">
                                @if ($account = auth('account')->user())
                                    <a title="{{ $account->name }}" href="{{ route('account.overview') }}">
                                        <div class="bb-account-sidebar-heading">
                                            <div class="d-flex gap-3">
                                                <div class="wrapper-image" style="">
                                                    {!! RvMedia::image($account->avatar_url, $account->name ) !!}
                                                </div>
                                                <div>
                                                    <div class="fs-6 name">{{ $account->name }}</div>
                                                    <div class="text-muted email">{{ $account->email }}</div>
                                                </div>
                                            </div>
                                        </div>
                                    </a>
                                @endif

                                @foreach (DashboardMenu::getAll('account') as $item)
                                    @continue(! $item['name'])

                                    <div @class(['bb-account-menu-item-wrapper', 'active' => $item['active']])>
                                        <x-core::icon :name="$item['icon']" />
                                        <a
                                                class="bb-account-menu-item"
                                                href="{{ $item['url'] }}"
                                                title="{{ $item['name'] }}"
                                        >
                                            {{ $item['name'] }}
                                        </a>
                                    </div>
                                @endforeach
                            </div>
                        </div>

                    </div>
                </div>

                <div class="col-md-9">
                    <div class="bb-profile-content">
                        <div class="bb-profile-header">
                            <div class="bb-profile-header-title">
                                @yield('title')
                            </div>
                        </div>
                        @yield('content')
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
