@extends(\ArchiElite\EventsBooking\Facades\EventsBookingHelper::viewPath('accounts.master'))

@section('title', __('Order information'))

@section('content')
    <div class="customer-order-detail">
        <div class="card mt-3">
            <div class="card-body">
                <div class="customer-order-detail">
                    <div class="row">
                        <div class="col-lg-12">
                            <p>
                                <span class="d-inline-block me-1">{{ __('Order number') }}: </span>
                                <strong>{{ $order->code }}</strong>
                            </p>
                            <p>
                                <span class="d-inline-block me-1">{{ __('Event') }}: </span>
                                <strong>{{ $order->event_name }}</strong>
                            </p>
                            @if($event = $order->event)
                                <p>
                                    <span class="d-inline-block me-1">{{ __('Event start at') }}: </span>
                                    <strong>{{ $event->started_at->translatedFormat('d M Y H:i:s') }}</strong>
                                </p>
                                <p>
                                    <span class="d-inline-block me-1">{{ __('Event address') }}: </span>
                                    <strong>{{ $event->address }}</strong>
                                </p>
                            @endif
                            <p>
                                <span class="d-inline-block me-1">{{ __('Time') }}: </span>
                                <strong>{{ $order->created_at->translatedFormat('d M Y H:i:s') }}</strong>
                            </p>
                            <p>
                                <span class="d-inline-block me-1">{{ __('Order status') }}: </span>
                                <strong class="text-info">{{ $order->status->label() }}</strong>
                            </p>
                            @if($order->cancellation_reason)
                                <p>
                                    <span class="d-inline-block me-1">{{ __('Cancellation Reason') }}: </span>
                                    <strong class="text-warning">{{ $order->cancellation_reason_message }}</strong>
                                </p>
                            @endif
                            @if (is_plugin_active('payment') && $order->payment->id)
                                <p>
                                    <span class="d-inline-block me-1">{{ __('Payment method') }}: </span>
                                    <strong class="text-info">{{ $order->payment->payment_channel->label() }}</strong>
                                </p>
                                <p>
                                    <span class="d-inline-block me-1">{{ __('Payment status') }}: </span>
                                    <strong class="text-info">{{ $order->payment->status->label() }}</strong>
                                </p>
                            @endif
                            @if ($order->description)
                                <p>
                                    <span class="d-inline-block me-1">{{ __('Note') }}: </span>
                                    <strong class="text-warning"><i>{{ $order->description }}</i></strong>
                                </p>
                            @endif
                            <p>
                                <span class="d-inline-block me-1">{{ __('Subtotal') }}: </span>
                                <strong>{{ format_price($order->subtotal) }}</strong>
                            </p>
                            <p>
                                <span class="d-inline-block me-1">{{ __('Tax') }}: </span>
                                <strong>{{ format_price($order->tax_amount) }}</strong>
                            </p>
                            <p>
                                <span class="d-inline-block me-1">{{ __('Discount') }}: </span>
                                <strong>{{ format_price($order->coupon_amount) }}</strong>
                            </p>
                            <p>
                                <span class="d-inline-block me-1">{{ __('Total') }}: </span>
                                <strong>{{ format_price($order->total) }}</strong>
                            </p>
                        </div>
                    </div>
                    <br>
                    @if($order->status->getValue() === 'completed')
                        <h5 class="mb-3">{{ __('Tickets') }}</h5>
                        <div>
                            <div class="table-responsive mb-3">
                                <table class="table table-striped table-hover align-middle">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{ __('Code') }}</th>
                                        <th>{{ __('Name') }}</th>
                                        <th>{{ __('Email') }}</th>
                                        <th class="text-end">{{ __('Action') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach ($order->tickets as $ticket)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $ticket->code }}</td>
                                            <td>{{ $ticket->name }}</td>
                                            <td>{{ $ticket->email }}</td>
                                            <td class="text-end">
                                                <a data-bb-toggle="view-ticket" data-href="{{ route('account.tickets.show', ['order' => $order, 'ticket' => $ticket]) }}" href="#" class="btn btn-sm btn-primary">
                                                    {{ __('View') }}
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    @include(\ArchiElite\EventsBooking\Facades\EventsBookingHelper::viewPath('includes.view-ticket-modal'))
@stop
