<div class="customer-order-detail">
    <div class="card border-0 mt-3">
        <div class="card-body p-0">
            <div class="customer-order-detail">
                <div class="row">
                    <div class="col-lg-12">
                        <p>
                            <span class="d-inline-block me-1">{{ __('Ticket Code') }}: </span>
                            <strong>{{ $ticket->code }}</strong>
                        </p>

                        <p>
                            <span class="d-inline-block me-1">{{ __('Name') }}: </span>
                            <strong>{{ $ticket->name }}</strong>
                        </p>

                        <p>
                            <span class="d-inline-block me-1">{{ __('Email') }}: </span>
                            <strong>{{ $ticket->email }}</strong>
                        </p>

                        @if($phone = $ticket->phone)
                            <p>
                                <span class="d-inline-block me-1">{{ __('Phone') }}: </span>
                                <strong>{{ $phone }}</strong>
                            </p>
                        @endif

                        <p>
                            <span class="d-inline-block me-1">{{ __('Check-in at') }}: </span>
                            <strong>{{ $ticket->checked_in_at ? $ticket->checked_in_at->translatedFormat('d M Y H:i:s'): __('No yet') }}</strong>
                        </p>
                        <p>
                            <span class="d-inline-block me-1">{{ __('Ticket status') }}: </span>
                            <strong class="text-info">{{ $ticket->status->label() }}</strong>
                        </p>

                        <p>
                            <span class="d-inline-block me-1">{{ __('QR Code') }}: </span>
                        </p>

                        @if($ticket->code)
                            <div class="text-center">
                                {{ RvMedia::image($ticket->qr_code_image, $ticket->code, 'thumb', attributes: ['width' => 100]) }}
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
