@php
    $quantity ??= 1;
@endphp

<div class="mb-3">
    @for($i = 0; $i < $quantity; $i++)
        <div class="card mb-3">
            <div class="card-header">
                <h4 class="card-title mb-0">{{ __('Ticket :number', ['number' => $i + 1]) }}</h4>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-6 mb-3">
                        <label for="name" class="form-label required">{{ __('Name') }} *</label>
                        <input type="text" name="tickets[{{ $i }}][name]" class="form-control" id="name" placeholder="{{ __('Enter name') }}">
                    </div>
                    <div class="col-lg-6 mb-3">
                        <label for="email" class="form-label">{{ __('Email') }} *</label>
                        <input type="email" name="tickets[{{ $i }}][email]" class="form-control" id="email" placeholder="{{ __('Enter email') }}">
                    </div>
                    <div class="col-lg-12 mb-3">
                        <label for="phone" class="form-label">{{ __('Phone') }}</label>
                        <input type="text" name="tickets[{{ $i }}][phone]" class="form-control" id="phone" placeholder="{{ __('Enter phone') }}">
                    </div>
                    <div class="col-lg-12">
                        <label for="note" class="form-label">{{ __('Note') }}</label>
                        <textarea class="form-control" name="tickets[{{ $i }}][note]" id="note" rows="3" placeholder="{{ __('Write Something...') }}"></textarea>
                    </div>
                </div>
            </div>
        </div>
    @endfor
</div>
