<?php

use ArchiElite\EventsBooking\Http\Controllers\Accounts\PublicController;
use ArchiElite\EventsBooking\Http\Controllers\CouponController;
use ArchiElite\EventsBooking\Http\Controllers\ExportAttendeeController;
use ArchiElite\EventsBooking\Http\Controllers\Fronts\CouponController as CouponControllerFront;
use ArchiElite\EventsBooking\Http\Controllers\ImportAttendeeController;
use ArchiElite\EventsBooking\Http\Controllers\Settings\AccountSettingController;
use ArchiElite\EventsBooking\Http\Controllers\Settings\CurrencySettingController;
use ArchiElite\EventsBooking\Http\Controllers\Settings\InvoiceSettingController;
use ArchiElite\EventsBooking\Http\Controllers\Settings\InvoiceTemplateSettingController;
use ArchiElite\EventsBooking\Models\Account;
use ArchiElite\EventsBooking\Models\Event;
use Botble\Base\Facades\AdminHelper;
use Botble\Slug\Facades\SlugHelper;
use Botble\Theme\Facades\Theme;
use Illuminate\Support\Facades\Route;

Route::group(['namespace' => 'ArchiElite\EventsBooking\Http\Controllers'], function () {
    AdminHelper::registerRoutes(function () {
        Route::group(['prefix' => 'events-bookings', 'as' => 'events-booking.'], function () {
            Route::resource('events', 'EventController')->parameters(['' => 'events']);
            Route::get('events/{id}/analytics', 'EventController@analytics')->name('events.analytics');
            Route::post('events/{id}/orders', 'EventController@getEventOrders')->name('events.get-orders');
            Route::post('events/{id}/attendees', 'EventController@getEventAttendees')->name('events.get-attendees');

            Route::resource('accounts', 'AccountController')->parameters(['' => 'accounts']);
            Route::resource('orders', 'OrderController')->parameters(['' => 'orders'])->only('index', 'edit', 'update', 'destroy');
            Route::post('orders/confirm-payment/{order}', 'OrderController@postConfirmPayment')->name('orders.confirm-payment');

            Route::resource('tickets', 'TicketController')->parameters(['' => 'tickets'])->only('index', 'edit', 'update', 'destroy');
            Route::resource('taxes', 'TaxController')->parameters(['' => 'taxes']);

            Route::group(['prefix' => 'coupons', 'as' => 'coupons.'], function (): void {
                Route::resource('', CouponController::class)
                    ->parameters(['' => 'coupon']);

                Route::post('generate-coupon', [
                    'as' => 'generate-coupon',
                    'uses' => 'CouponController@generateCouponCode',
                    'permission' => 'coupons.index',
                ]);

                Route::delete('deletes', [
                    'as' => 'deletes',
                    'uses' => 'CouponController@deletes',
                    'permission' => 'coupons.destroy',
                ]);
            });

            Route::resource('invoices', 'InvoiceController')->parameters(['' => 'invoices'])->only('index', 'edit', 'update', 'destroy');
            Route::get('generate-invoices', 'InvoiceController@generateInvoices')->name('invoices.generate-invoices');
            Route::get('generate-invoices/{invoice}', 'InvoiceController@getGenerateInvoice')->name('invoices.generate-invoice');

            Route::get('/booking-reports/bookings', [
                'uses' => 'BookingReportController@index',
                'as' => 'booking.reports.index',
            ]);

            Route::post('recent-bookings', [
                'as' => 'booking.reports.recent-bookings',
                'uses' => 'BookingReportController@getRecentBookings',
                'permission' => 'events-booking.booking.reports.index',
            ]);

            Route::post('ajax/resend-mail/{orderId}/{ticketId}', 'OrderController@resendMail')->name('ajax.order.resend-mail');
            Route::get('ajax/get-events', 'PublicController@ajaxGetEvents')->name('ajax.events');
            Route::get('ajax/choose-events/{id}', 'PublicController@ajaxChooseEvent')->name('ajax.choose-event');
        });

        Route::group(['prefix' => 'settings', 'as' => 'events-booking.settings.', 'permission' => 'events-booking.settings'], function () {
            Route::get('currencies', [CurrencySettingController::class, 'edit'])->name('currencies');
            Route::put('currencies', [CurrencySettingController::class, 'update'])->name('currencies.update');

            Route::get('accounts', [AccountSettingController::class, 'edit'])->name('accounts');
            Route::put('accounts', [AccountSettingController::class, 'update'])->name('accounts.update');

            Route::get('invoices', [InvoiceSettingController::class, 'edit'])->name('invoices');
            Route::put('invoices', [InvoiceSettingController::class, 'update'])->name('invoices.update');

            Route::get('invoice-template', [InvoiceTemplateSettingController::class, 'edit'])->name('invoice-template');
            Route::put('invoice-template', [InvoiceTemplateSettingController::class, 'update'])->name('invoice-template.update');
            Route::put('invoice-template/reset', [InvoiceTemplateSettingController::class, 'reset'])->name('invoice-template.reset');
            Route::get('invoice-template/preview', [InvoiceTemplateSettingController::class, 'preview'])->name('invoice-template.preview');
        });
    });

    if (defined('THEME_MODULE_SCREEN_NAME')) {
        Theme::registerRoutes(function () {
            Route::get(SlugHelper::getPrefix(Event::class, 'events') . '/{slug}', 'PublicController@getEvent');
            Route::get(SlugHelper::getPrefix(Account::class, 'speakers') . '/{slug}', 'PublicController@getSpeaker');

            Route::post('booking', 'PublicController@postBooking')->name('public.booking');
            Route::get('booking/{token}', 'PublicController@getBooking')->name('public.booking.form');
            Route::post('checkout', 'PublicController@postCheckout')->name('public.booking.checkout');
            Route::get('checkout/{transactionId}', 'PublicController@checkoutSuccess')->name('public.booking.information');

            Route::get('currency/switch/{code?}', [PublicController::class, 'switchCurrency'])->name('public.currency.switch');

            Route::prefix('coupon')->name('coupon.')->group(function (): void {
                Route::post('apply', [CouponControllerFront::class, 'apply'])->name('apply');
                Route::post('remove', [CouponControllerFront::class, 'remove'])->name('remove');
                Route::get('refresh', [CouponControllerFront::class, 'refresh'])->name('refresh');
            });

            Route::get('ajax/calculate-amount', 'PublicController@ajaxCalculateBookingAmount')
                ->name('public.booking.ajax.calculate-amount');

            Route::group([
                'namespace' => 'Accounts',
                'middleware' => ['account.guest'],
                'as' => 'account.',
            ], function () {
                Route::get('login', 'LoginController@showLoginForm')->name('login');
                Route::post('login', 'LoginController@login')->name('login.post');

                Route::get('register', 'RegisterController@showRegistrationForm')->name('register');
                Route::post('register', 'RegisterController@register')->name('register.post');
                Route::get('register/confirm/resend', 'RegisterController@resendConfirmation')->name('resend_confirmation');
                Route::get('register/confirm/{user}', 'RegisterController@confirm')->name('confirm');

                Route::get('password/email', 'ForgotPasswordController@showLinkRequestForm')->name('password.reset');
                Route::post('password/email', 'ForgotPasswordController@sendResetLinkEmail')->name('password.request');
                Route::post('password/reset', 'ResetPasswordController@reset')->name('password.reset.post');
                Route::get('password/reset', 'ForgotPasswordController@showLinkRequestForm')->name('password.reset');
                Route::get('password/reset/{token}', 'ResetPasswordController@showResetForm')->name('password.reset.update');
            });

            Route::group([
                'namespace' => 'Accounts',
                'middleware' => ['account'],
                'as' => 'account.',
                'prefix' => 'account',
            ], function () {
                Route::get('overview', 'PublicController@getOverview')->name('overview');
                Route::get('edit-account', 'PublicController@getEditAccount')->name('edit-account');
                Route::post('edit-account', 'PublicController@postEditAccount')->name('edit-account.post');
                Route::get('change-password', 'PublicController@getChangePassword')->name('change-password');
                Route::post('change-password', 'PublicController@postChangePassword')->name('change-password.post');
                Route::get('logout', 'LoginController@logout')->name('logout');

                Route::get('orders', 'OrderController@index')->name('orders');
                Route::get('orders/{order}', 'OrderController@show')->name('orders.show');
                Route::get('orders/{order}/tickets/{ticket}', 'TicketController@show')->name('tickets.show');

                Route::get('generate-invoices/{invoice}', 'PublicController@getGenerateInvoice')->name('invoices.generate-invoice');
            });

            Route::prefix('tools/data-synchronize')->name('tools.data-synchronize.')->group(function (): void {
                Route::prefix('export')->name('export.')->group(function (): void {
                    Route::group(['prefix' => 'attendees', 'as' => 'attendees.', 'permission' => 'events-booking.accounts.export'], function (): void {
                        Route::get('/', [ExportAttendeeController::class, 'index'])->name('index');
                        Route::post('/', [ExportAttendeeController::class, 'store'])->name('store');
                    });
                });

                Route::prefix('import')->name('import.')->group(function (): void {
                    Route::group(['prefix' => 'attendees', 'as' => 'attendees.', 'permission' => 'events-booking.accounts.export'], function (): void {
                        Route::get('/', [ImportAttendeeController::class, 'index'])->name('index');
                        Route::post('validate', [ImportAttendeeController::class, 'validateData'])->name('validate');
                        Route::post('import', [ImportAttendeeController::class, 'import'])->name('store');
                        Route::post('download-example', [ImportAttendeeController::class, 'downloadExample'])->name('download-example');
                    });
                });
            });
        });
    }
});

