<?php

namespace ArchiElite\EventsBooking\Enums;

use Botble\Base\Facades\Html;
use Botble\Base\Supports\Enum;
use Illuminate\Support\HtmlString;

/**
 * @method static OrderStatusEnum PENDING()
 * @method static OrderStatusEnum PROCESSING()
 * @method static OrderStatusEnum COMPLETED()
 * @method static OrderStatusEnum CANCELLED()
 */
class OrderStatusEnum extends Enum
{
    public const PENDING = 'pending';
    public const PROCESSING = 'processing';
    public const COMPLETED = 'completed';
    public const CANCELLED = 'cancelled';
    public const REFUNDED = 'refunded';

    public static $langPath = 'plugins/events-booking::events-booking.enums.orders.statuses';

    public function toHtml(): string|HtmlString
    {
        return match ($this->value) {
            self::CANCELLED => Html::tag('span', self::CANCELLED()->label(), ['class' => 'badge bg-danger text-danger-fg']),
            self::PENDING => Html::tag('span', self::PENDING()->label(), ['class' => 'badge bg-warning text-warning-fg']),
            self::PROCESSING => Html::tag('span', self::PROCESSING()->label(), ['class' => 'badge bg-info text-info-fg']),
            self::COMPLETED => Html::tag('span', self::COMPLETED()->label(), ['class' => 'badge bg-success text-success-fg']),
            self::REFUNDED => Html::tag('span', self::REFUNDED()->label(), ['class' => 'badge bg-secondary text-secondary-fg']),
            default => parent::toHtml(),
        };
    }
}
