<?php

namespace ArchiElite\EventsBooking\Facades;

use ArchiElite\EventsBooking\Supports\CurrencySupport;
use Illuminate\Support\Facades\Facade;

/**
 * @method static void setApplicationCurrency(\ArchiElite\EventsBooking\Models\Currency $currency)
 * @method static \ArchiElite\EventsBooking\Models\Currency|null getApplicationCurrency()
 * @method static \ArchiElite\EventsBooking\Models\Currency|null getDefaultCurrency()
 * @method static \Illuminate\Support\Collection currencies()
 * @method static string|null detectedCurrencyCode()
 * @method static array countryCurrencies()
 * @method static array currencyCodes()
 *
 * @see \ArchiElite\EventsBooking\Supports\CurrencySupport
 */
class Currency extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return CurrencySupport::class;
    }
}
