<?php

namespace ArchiElite\EventsBooking\Facades;

use ArchiElite\EventsBooking\Supports\EventsBookingHelper as EventsBookingSupport;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Facade;

/**
 * @method static string getLoginOption()
 * @method static bool isLoginUsingPhone()
 * @method static bool isEnableEmailVerification()
 * @method static string viewPath(string $view)
 * @method static array getAvailableCountries()
 * @method static bool isZipCodeEnabled()
 * @method static bool disableOrderInvoiceUntilOrderConfirmed()
 * @method static string|null getCountryNameById(int|string|null $countryId)
 * @method static array getDateRangeInReport(Request $request)
 *
 * @see \ArchiElite\EventsBooking\Supports\EventsBookingHelper
 */
class EventsBookingHelper extends Facade
{
    protected static function getFacadeAccessor(): string
    {
        return EventsBookingSupport::class;
    }
}
