<?php

namespace ArchiElite\EventsBooking\Forms\Settings;

use ArchiElite\EventsBooking\Facades\EventsBookingHelper;
use ArchiElite\EventsBooking\Http\Requests\Settings\AccountSettingRequest;
use Botble\Base\Forms\FieldOptions\OnOffFieldOption;
use Botble\Base\Forms\FieldOptions\RadioFieldOption;
use Botble\Base\Forms\Fields\OnOffCheckboxField;
use Botble\Base\Forms\Fields\RadioField;
use Botble\Setting\Forms\SettingForm;

class AccountSettingForm extends SettingForm
{
    public function setup(): void
    {
        parent::setup();

        $this
            ->setSectionTitle(trans('plugins/events-booking::settings.account.title'))
            ->setSectionDescription(trans('plugins/events-booking::settings.account.description'))
            ->setFormOptions([
                'class' => 'main-setting-form',
            ])
            ->setValidatorClass(AccountSettingRequest::class)
            ->add(
                'verify_customer_email',
                OnOffCheckboxField::class,
                OnOffFieldOption::make()
                    ->label(trans('plugins/events-booking::settings.account.form.verify_customer_email'))
                    ->helperText(trans('plugins/events-booking::settings.account.form.verify_customer_email_helper'))
                    ->value(EventsBookingHelper::isEnableEmailVerification())
                    ->toArray()
            )
            ->add(
                'login_option',
                RadioField::class,
                RadioFieldOption::make()
                    ->label(trans('plugins/events-booking::settings.account.form.login_option'))
                    ->selected(setting('events_booking_login_option', 'email_or_phone'))
                    ->choices([
                        'email' => trans('plugins/events-booking::settings.account.form.login_with_email'),
                        'phone' => trans('plugins/events-booking::settings.account.form.login_with_phone'),
                        'email_or_phone' => trans('plugins/events-booking::settings.account.form.login_with_email_or_phone'),
                    ])
                    ->toArray(),
            );
    }
}
