<?php

namespace ArchiElite\EventsBooking\Forms\Settings;

use ArchiElite\EventsBooking\Http\Requests\Settings\CurrencySettingRequest;
use ArchiElite\EventsBooking\Models\Currency;
use Botble\Base\Facades\Assets;
use Botble\Setting\Forms\SettingForm;

class CurrencySettingForm extends SettingForm
{
    public function setup(): void
    {
        parent::setup();

        Assets::addScripts(['jquery-ui'])
            ->addScriptsDirectly('vendor/core/plugins/events-booking/js/currencies.js')
            ->addStylesDirectly('vendor/core/plugins/events-booking/css/currencies.css');

        $currencies = Currency::query()
            ->orderBy('order')
            ->get()
            ->all();

        $this
            ->setSectionTitle(trans('plugins/events-booking::settings.currency.title'))
            ->setSectionDescription(trans('plugins/events-booking::settings.currency.description'))
            ->setFormOptions([
                'class' => 'main-setting-form',
            ])
            ->contentOnly()
            ->setValidatorClass(CurrencySettingRequest::class)
            ->add('enable_auto_detect_visitor_currency', 'onOffCheckbox', [
                'label' => trans('plugins/events-booking::currency.enable_auto_detect_visitor_currency'),
                'value' => setting('events_booking_enable_auto_detect_visitor_currency', false),
                'help_block' => [
                    'text' => trans('plugins/events-booking::currency.auto_detect_visitor_currency_description'),
                ],
            ])
            ->add('add_space_between_price_and_currency', 'onOffCheckbox', [
                'label' => trans('plugins/events-booking::currency.add_space_between_price_and_currency'),
                'value' => setting('events_booking_add_space_between_price_and_currency', false),
            ])
            ->add('thousands_separator', 'customSelect', [
                'label' => trans('plugins/events-booking::currency.thousands_separator'),
                'selected' => setting('events_booking_thousands_separator', ','),
                'choices' => [
                    ',' => trans('plugins/events-booking::currency.separator_comma'),
                    '.' => trans('plugins/events-booking::currency.separator_period'),
                    'space' => trans('plugins/events-booking::currency.separator_space'),
                ],
            ])
            ->add('data_currencies', 'html', [
                'html' => view('plugins/events-booking::settings.partials.currencies.data-currency-fields', compact('currencies')),
            ])
            ->add('currency_table', 'html', [
                'html' => view('plugins/events-booking::settings.partials.currencies.currency-table'),
            ]);
    }
}
