<?php

namespace ArchiElite\EventsBooking\Forms;

use ArchiElite\EventsBooking\Http\Requests\TaxRequest;
use ArchiElite\EventsBooking\Models\Tax;
use Botble\Base\Forms\FieldOptions\NumberFieldOption;
use Botble\Base\Forms\FieldOptions\StatusFieldOption;
use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\Fields\NumberField;
use Botble\Base\Forms\Fields\SelectField;
use Botble\Base\Forms\Fields\TextField;
use Botble\Base\Forms\FormAbstract;

class TaxForm extends FormAbstract
{
    public function setup(): void
    {
        $this
            ->model(Tax::class)
            ->setValidatorClass(TaxRequest::class)
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(trans('plugins/events-booking::tax.form.title'))
                    ->required()
            )
            ->add(
                'percentage',
                NumberField::class,
                NumberFieldOption::make()
                    ->label(trans('plugins/events-booking::tax.form.percentage'))
                    ->required()
            )
            ->add(
                'priority',
                NumberField::class,
                NumberFieldOption::make()
                    ->defaultValue(0)
                    ->label(trans('plugins/events-booking::tax.form.priority'))
            )
            ->add('status', SelectField::class, StatusFieldOption::make()->toArray())
            ->setBreakFieldPoint('status');

    }
}
