<?php

namespace ArchiElite\EventsBooking\Http\Controllers\Accounts;

use ArchiElite\EventsBooking\Forms\Fronts\Auth\ResetPasswordForm;
use Botble\ACL\Traits\ResetsPasswords;
use Botble\Base\Http\Controllers\BaseController;
use Botble\SeoHelper\Facades\SeoHelper;
use Botble\Theme\Facades\Theme;
use Illuminate\Contracts\Auth\PasswordBroker;
use Illuminate\Contracts\Auth\StatefulGuard;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Password;

class ResetPasswordController extends BaseController
{
    use ResetsPasswords;

    public string $redirectTo = '/';

    public function __construct()
    {
        $this->middleware('account.guest');
    }

    public function showResetForm(Request $request, $token = null)
    {
        SeoHelper::setTitle(__('Reset Password'));

        Theme::breadcrumb()
            ->add(__('Reset Password'), route('account.password.reset'));

        return Theme::scope(
            'events-booking.accounts.passwords.reset',
            [
                'token' => $token,
                'email' => $request->input('email'),
                'form' => ResetPasswordForm::create(),
            ],
            'plugins/events-booking::themes.accounts.passwords.reset'
        )->render();
    }

    public function broker(): PasswordBroker
    {
        return Password::broker('accounts');
    }

    protected function guard(): StatefulGuard
    {
        return auth('account');
    }
}
