<?php

namespace ArchiElite\EventsBooking\Http\Controllers;

use ArchiElite\EventsBooking\Enums\TicketStatusEnum;
use ArchiElite\EventsBooking\Http\Requests\UpdateTicketRequest;
use ArchiElite\EventsBooking\Models\Ticket;
use ArchiElite\EventsBooking\Tables\TicketTable;
use Botble\Base\Http\Actions\DeleteResourceAction;
use Botble\Base\Http\Controllers\BaseController;

class TicketController extends BaseController
{
    public function __construct()
    {
        $this
            ->breadcrumb()
            ->add(trans('plugins/events-booking::events-booking.name'))
            ->add(trans('plugins/events-booking::events-booking.ticket.name'), route('events-booking.tickets.index'));
    }

    public function index(TicketTable $table)
    {
        $this->pageTitle(trans('plugins/events-booking::events-booking.ticket.name'));

        return $table->renderTable();
    }

    public function edit(Ticket $ticket)
    {
        $this->pageTitle(trans('core/base::forms.edit_item', ['name' => $ticket->code]));

        $ticketStatuses = TicketStatusEnum::labels();

        return view('plugins/events-booking::tickets.edit', compact('ticket', 'ticketStatuses'));
    }

    public function update(Ticket $ticket, UpdateTicketRequest $request)
    {
        $ticket->update($request->validated());

        return $this
            ->httpResponse()
            ->setPreviousUrl(route('events-booking.tickets.index'))
            ->withUpdatedSuccessMessage();
    }

    public function destroy(Ticket $ticket)
    {
        return DeleteResourceAction::make($ticket);
    }
}
