<?php

namespace ArchiElite\EventsBooking\Http\Requests;

use ArchiElite\EventsBooking\Enums\AccountStatusEnum;
use ArchiElite\EventsBooking\Enums\AccountTypeEnum;
use Botble\Base\Facades\BaseHelper;
use Botble\Support\Http\Requests\Request;
use Illuminate\Validation\Rule;

class AccountRequest extends Request
{
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:120', 'min:2'],
            'email' => ['required', 'string', 'email', 'unique:eb_accounts,email'],
            'phone' => ['nullable', 'string', ...explode('|', BaseHelper::getPhoneValidationRule())],
            'avatar' => ['nullable', 'string'],
            'dob' => ['nullable', 'date'],
            'company' => ['nullable', 'string'],
            'position' => ['nullable', 'string'],
            'password' => ['required', 'string', 'min:6', 'confirmed'],
            'type' => ['required', 'string', Rule::in(AccountTypeEnum::values())],
            'status' => ['required', 'string', Rule::in(AccountStatusEnum::values())],
        ];
    }
}
