<?php

namespace ArchiElite\EventsBooking\Http\Requests;

use ArchiElite\EventsBooking\Enums\EventStatusEnum;
use Botble\Support\Http\Requests\Request;
use Illuminate\Validation\Rule;

class EventRequest extends Request
{
    public function rules(): array
    {
        return [
            'name' => ['required', 'string'],
            'account_id' => ['required', 'string', 'exists:eb_accounts,id'],
            'price' => ['nullable', 'numeric', 'min:0'],
            'short_description' => ['nullable', 'string', 'max:255'],
            'description' => ['nullable', 'string', 'max:1000'],
            'content' => ['required', 'string', 'max:10000'],
            'image' => ['nullable', 'string'],
            'unique_id' => ['nullable', 'string', 'unique:eb_events,unique_id,' . $this->route('event.id')],
            'address' => ['required', 'string'],
            'country_id' => ['nullable', 'string'],
            'state_id' => ['nullable', 'string'],
            'city_id' => ['nullable', 'string'],
            'started_at' => ['required', 'date'],
            'ended_at' => ['nullable', 'date'],
            'booking_closed_at' => ['nullable', 'date'],
            'seats' => ['required', 'numeric'],
            'status' => ['required', 'string', Rule::in(EventStatusEnum::values())],
            'latitude' => ['max:20', 'nullable', 'regex:/^[-]?(([0-8]?[0-9])\.(\d+))|(90(\.0+)?)$/'],
            'longitude' => [
                'max:20',
                'nullable',
                'regex:/^[-]?((((1[0-7][0-9])|([0-9]?[0-9]))\.(\d+))|180(\.0+)?)$/',
            ],
            'speaker_data' => ['nullable'],
            'speaker_data.*.0.value' => ['numeric', 'min:0'],
            'speaker_data.*.1.value' => ['required', 'string', 'exists:eb_accounts,id'],
            'speaker_data.*.2.value' => ['nullable', 'string'],
            'speaker_data.*.3.value' => ['nullable', 'string'],
            'speaker_data.*.4.value' => ['nullable', 'date'],
            'speaker_data.*.5.value' => ['nullable', 'date'],
            'tax_id' => ['nullable', 'string', 'exists:eb_taxes,id'],
        ];
    }
}
