<?php

namespace ArchiElite\EventsBooking\Http\Requests\Fronts;

use ArchiElite\EventsBooking\Facades\EventsBookingHelper;
use Botble\Base\Facades\BaseHelper;
use Botble\Base\Rules\EmailRule;
use Botble\Support\Http\Requests\Request;
use Illuminate\Validation\Factory;

class LoginRequest extends Request
{
    public function rules(): array
    {
        $rules = [
            'email' => ['required', 'string', ...match (EventsBookingHelper::getLoginOption()) {
                'phone' => BaseHelper::getPhoneValidationRule(true),
                'email' => [new EmailRule()],
                default => [],
            }],
            'password' => ['required', 'string'],
        ];

        return apply_filters('events_booking_account_login_form_validation_rules', $rules);
    }

    public function attributes(): array
    {
        return apply_filters('events_booking_account_login_form_validation_attributes', [
            'email' => match (EventsBookingHelper::getLoginOption()) {
                'phone' => __('Phone'),
                'email_or_phone' => __('Email or Phone number'),
                default => __('Email'),
            },
            'password' => __('Password'),
        ]);
    }

    public function messages(): array
    {
        return apply_filters('events_booking_account_login_form_validation_messages', []);
    }

    public function isEmail($value): bool
    {
        $validator = $this->container->make(Factory::class);

        return $validator
            ->make(['email' => $value], ['email' => ['email']])
            ->passes();
    }
}
