<?php

namespace ArchiElite\EventsBooking\Listeners;

use ArchiElite\EventsBooking\Events\OrderCreated;
use Botble\Base\Events\AdminNotificationEvent;
use Botble\Base\Supports\AdminNotificationItem;

class OrderCreatedNotification
{
    public function handle(OrderCreated $event): void
    {
        event(new AdminNotificationEvent(
            AdminNotificationItem::make()
                ->title(trans('plugins/events-booking::notification.new_order_notifications.new_order'))
                ->description(trans('plugins/events-booking::notification.new_order_notifications.description', [
                    'customer' => $event->order->account_name,
                    'quantity' => $quantity = $event->order->tickets->count(),
                    'ticket' => $quantity > 1 ? 'tickets' : 'ticket',
                ]))
                ->action(trans('plugins/events-booking::notification.view'), route('events-booking.orders.edit', $event->order->id))
        ));
    }
}
