<?php

namespace ArchiElite\EventsBooking\Listeners;

use ArchiElite\EventsBooking\Events\OrderPaymentConfirmedEvent;
use Botble\Base\Events\AdminNotificationEvent;
use Botble\Base\Supports\AdminNotificationItem;

class OrderPaymentConfirmedNotification
{
    public function handle(OrderPaymentConfirmedEvent $event): void
    {
        event(new AdminNotificationEvent(
            AdminNotificationItem::make()
                ->title(trans('plugins/events-booking::notification.confirm_payment_notifications.confirm_payment'))
                ->description(trans('plugins/events-booking::notification.confirm_payment_notifications.description', [
                    'order' => $event->order->code,
                    'amount' => format_price($event->order->amount),
                    'by' => $event->confirmedBy->username,
                ]))
                ->action(trans('plugins/events-booking::notification.view'), route('events-booking.orders.edit', $event->order->id))
        ));
    }
}
