<?php

namespace ArchiElite\EventsBooking\Models;

use ArchiElite\EventsBooking\Enums\CouponTypeEnum;
use Botble\Base\Models\BaseModel;

class Coupon extends BaseModel
{
    protected $table = 'eb_coupons';

    protected $fillable = [
        'type',
        'code',
        'value',
        'quantity',
        'total_used',
        'expires_date',
    ];

    protected $casts = [
        'type' => CouponTypeEnum::class,
        'value' => 'decimal:2',
        'quantity' => 'int',
        'total_used' => 'int',
        'expires_date' => 'datetime',
    ];
}
