<?php

namespace ArchiElite\EventsBooking\Models;

use ArchiElite\EventsBooking\Enums\OrderStatusEnum;
use ArchiElite\EventsBooking\Models\Concerns\BelongsToEvent;
use Botble\Base\Models\BaseModel;
use Botble\Payment\Models\Payment;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphOne;

class Order extends BaseModel
{
    use BelongsToEvent;

    protected $table = 'eb_orders';

    protected $fillable = [
        'code',
        'token',
        'event_id',
        'event_name',
        'event_ticket_price',
        'account_id',
        'currency_id',
        'account_name',
        'account_email',
        'note',
        'private_note',
        'price',
        'quantity',
        'subtotal',
        'total',
        'tax_amount',
        'coupon_amount',
        'coupon_code',
        'status',
        'completed_at',
    ];

    protected $casts = [
        'status' => OrderStatusEnum::class,
        'completed_at' => 'datetime',
    ];

    public function event(): BelongsTo
    {
        return $this->belongsTo(Event::class, 'event_id');
    }

    public function tickets(): HasMany
    {
        return $this->hasMany(Ticket::class, 'order_id');
    }

    public function account(): BelongsTo
    {
        return $this->belongsTo(Account::class, 'account_id');
    }

    public function payment(): BelongsTo
    {
        return $this->belongsTo(Payment::class, 'payment_id');
    }

    public function invoice(): MorphOne
    {
        return $this->morphOne(Invoice::class, 'reference');
    }

    public function isCompleted(): bool
    {
        return $this->status == OrderStatusEnum::COMPLETED;
    }
}
