<?php

namespace ArchiElite\EventsBooking\Services;

use ArchiElite\EventsBooking\Enums\OrderStatusEnum;
use ArchiElite\EventsBooking\Models\Order;
use Botble\Payment\Enums\PaymentStatusEnum;
use Botble\Payment\Models\Payment;

class OrderService
{
    public function processBooking(int $orderId, ?string $chargeId = null): ?Order
    {
        /**
         * @var Order $order
         */
        $order = Order::query()->find($orderId);

        if (! $order) {
            return null;
        }

        if ($chargeId && is_plugin_active('payment')) {
            $payment = Payment::query()->where(['charge_id' => $chargeId])->first();

            if ($payment) {
                $order->payment_id = $payment->getKey();

                if ($payment->status == PaymentStatusEnum::COMPLETED) {
                    $order->status = OrderStatusEnum::COMPLETED;
                }

                $order->save();
            }
        }

        return $order;
    }
}
