<?php

namespace ArchiElite\EventsBooking\Tables\Events;

use ArchiElite\EventsBooking\Models\Account;
use ArchiElite\EventsBooking\Models\Event;
use Botble\Table\Abstracts\TableAbstract;
use Botble\Table\BulkChanges\CreatedAtBulkChange;
use Botble\Table\Columns\Column;
use Botble\Table\Columns\CreatedAtColumn;
use Botble\Table\Columns\IdColumn;
use Botble\Table\Columns\NameColumn;
use Botble\Table\Columns\StatusColumn;
use Illuminate\Database\Eloquent\Builder;

class AttendeeTable extends TableAbstract
{
    public string|int $eventId;

    public function setup(): void
    {
        $this
            ->model(Account::class)
            ->addColumns([
                IdColumn::make(),
                NameColumn::make()->route('events-booking.accounts.edit'),
                Column::make('email')->label(trans('plugins/events-booking::events-booking.account.form.email')),
                StatusColumn::make(),
                CreatedAtColumn::make(),
            ])
            ->addBulkChanges([
                CreatedAtBulkChange::make(),
            ])
            ->queryUsing(function (Builder $query) {
                $event = Event::query()
                    ->where('id', $this->eventId)
                    ->with('attendees')
                    ->first();

                $attendeeIds = $event ? $event->attendees->pluck('id')->all() : [];

                $query
                    ->whereIn('id', $attendeeIds)
                    ->select([
                        'id',
                        'name',
                        'email',
                        'status',
                        'created_at',
                    ]);
            });

        $this->type = self::TABLE_TYPE_SIMPLE;
        $this->defaultSortColumn = 0;
        $this->view = $this->simpleTableView();
    }

    public function setEventId(string $eventId): AttendeeTable
    {
        $this->eventId = $eventId;

        return $this;
    }

    protected function simpleTableView(): string
    {
        return 'plugins/events-booking::tables.simple-table';
    }
}
