<?php

namespace ArchiElite\EventsBooking\Widgets;

use ArchiElite\EventsBooking\Enums\AccountTypeEnum;
use ArchiElite\EventsBooking\Models\Account;
use Botble\Base\Widgets\Card;
use Carbon\CarbonPeriod;

class CustomerCard extends Card
{
    public function getOptions(): array
    {
        $data = Account::query()
            ->where('type', AccountTypeEnum::ATTENDEE)
            ->whereDate('created_at', '>=', $this->startDate)
            ->whereDate('created_at', '<=', $this->endDate)
            ->selectRaw('count(id) as total, date_format(created_at, "' . $this->dateFormat . '") as period')
            ->groupBy('period')
            ->pluck('total')
            ->toArray();

        return [
            'series' => [
                [
                    'data' => $data,
                ],
            ],
        ];
    }

    public function getViewData(): array
    {
        $count = Account::query()
            ->where('type', AccountTypeEnum::ATTENDEE)
            ->whereDate('created_at', '>=', $this->startDate)
            ->whereDate('created_at', '<=', $this->endDate)
            ->count();

        $startDate = clone $this->startDate;
        $endDate = clone $this->endDate;

        $currentPeriod = CarbonPeriod::create($startDate, $endDate);
        $previousPeriod = CarbonPeriod::create($startDate->subDays($currentPeriod->count()), $endDate->subDays($currentPeriod->count()));

        $currentCustomers = Account::query()
            ->where('type', AccountTypeEnum::ATTENDEE)
            ->whereDate('created_at', '>=', $currentPeriod->getStartDate())
            ->whereDate('created_at', '<=', $currentPeriod->getEndDate())
            ->count();

        $previousCustomers = Account::query()
            ->where('type', AccountTypeEnum::ATTENDEE)
            ->whereDate('created_at', '>=', $previousPeriod->getStartDate())
            ->whereDate('created_at', '<=', $previousPeriod->getEndDate())
            ->count();

        $result = $currentCustomers - $previousCustomers;

        $result > 0 ? $this->chartColor = '#4ade80' : $this->chartColor = '#ff5b5b';

        return array_merge(parent::getViewData(), [
            'content' => view(
                'plugins/events-booking::reports.widgets.customer-card',
                compact('count', 'result')
            )->render(),
        ]);
    }
}
