<?php

namespace ArchiElite\EventsBooking\Widgets;

use ArchiElite\EventsBooking\Enums\AccountTypeEnum;
use ArchiElite\EventsBooking\Models\Account;
use ArchiElite\EventsBooking\Widgets\Traits\HasCategory;
use Botble\Base\Widgets\Chart;

class CustomerChart extends Chart
{
    use HasCategory;

    protected int $columns = 6;

    public function getLabel(): string
    {
        return trans('plugins/events-booking::booking-reports.customers_chart');
    }

    public function getOptions(): array
    {
        $data = Account::query()
            ->where('type', AccountTypeEnum::ATTENDEE)
            ->groupBy('period')
            ->selectRaw('count(id) as total, date_format(created_at, "' . $this->dateFormat . '") as period')
            ->whereDate('created_at', '>=', $this->startDate)
            ->whereDate('created_at', '<=', $this->endDate)
            ->pluck('total', 'period')
            ->all();

        return [
            'series' => [
                [
                    'name' => trans('plugins/events-booking::booking-reports.number_of_customers'),
                    'data' => array_values($data),
                ],
            ],
            'xaxis' => [
                'categories' => $this->translateCategories($data),
            ],
        ];
    }
}
