@if ($event)
    @php
        $bgColor = Arr::get($config, 'background_color');
        $bgImage = Arr::get($config, 'background_image');
        $bgImage = $bgImage ? RvMedia::getImageUrl($bgImage) : null;

        $variablesStyle = [
            "--widget-background-color: $bgColor" => $bgColor,
            "--widget-background-image: url($bgImage)" => $bgImage,
        ];
    @endphp

    <div
        class="widget-upcoming-event cta3-section-area sp1"
        @style($variablesStyle)
    >
        <img
            src="{{ Theme::asset()->url('images/shapes/elements9.png') }}"
            alt=""
            class="elements9"
        />
        <img
            src="{{ Theme::asset()->url('images/shapes/elements18.png') }}"
            alt=""
            class="elements18"
        />
        <img
            src="{{ Theme::asset()->url('images/shapes/elements24.png') }}"
            alt=""
            class="elements24"
        />
        <div class="date-btn aniamtion-key-1">
            <h4>{{ $event->started_at->format('d') }}</h4>
            <div class="space14"></div>
            <p>{{ $event->started_at->format('M') }}</p>
            <div class="space20"></div>
            <a href="{{ $event->url }}">{!! BaseHelper::clean(Arr::get($config, 'button_label') ?: __('Buy Ticket')) !!}</a>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-lg-7">
                    <div class="row">
                        <div class="col-lg-4 col-md-4">
                            <div class="cta-counter-box">
                                <img
                                    src="{{ Theme::asset()->url('images/shapes/elements23.png') }}"
                                    alt=""
                                    class="elements23 keyframe5"
                                />
                                <h2><span
                                        class="odometer"
                                        data-count="{{ $event->booked_seats }}"
                                    ></span></h2>
                                <div class="space14"></div>
                                <p>{{ __('Attendance') }}</p>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-4">
                            <div class="cta-counter-box">
                                <img
                                    src="{{ Theme::asset()->url('images/shapes/elements23.png') }}"
                                    alt=""
                                    class="elements23 keyframe5"
                                />
                                <h2><span
                                        class="odometer"
                                        data-count="{{ $event->seats - $event->booked_seats }}"
                                    ></span></h2>
                                <div class="space14"></div>
                                <p>{{ __('Empty slot') }}</p>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-4">
                            <div class="cta-counter-box">
                                <img
                                    src="{{ Theme::asset()->url('images/shapes/elements23.png') }}"
                                    alt=""
                                    class="elements23 keyframe5"
                                />
                                <h2><span
                                        class="odometer"
                                        data-count="{{ $event->speakers_count }}"
                                    ></span></h2>
                                <div class="space14"></div>
                                <p>{{ __('Speakers') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-1"></div>

                @if ($image = Arr::get($config, 'image'))
                    <div class="col-lg-3">
                        <div class="img1">
                            {{ RvMedia::image($image, 'image') }}}
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endif
