@php
    $style = [];
    $bgColor = theme_option('header_background_color', '#313131');
    $textColor = theme_option('header_text_color', '#ffffff');
    $font = theme_option('primary_font', 'sans-serif');
    $isTransparent = theme_option('is_header_transparent', false) && Theme::get('isHomepage');

    if ($textColor) {
        $style["--header-text-color: $textColor"] = $textColor;
    }

    if ($bgColor !== 'transparent') {
        $style["--header-background-color: $bgColor"] = $bgColor;
    }

    $style["--header-font: $font"] = $font;
@endphp

<header>
    <div
        @class([
            'header-area homepage10 header header-sticky d-none d-lg-block',
            'no-transparent' => !$isTransparent,
        ])
        id="header"
        @style($style)
    >
        {!! Theme::partial('header.content') !!}
    </div>
</header>

{!! Theme::partial('header.mobile') !!}
