<?php

use ArchiElite\Announcement\Models\Announcement;
use Botble\Base\Facades\BaseHelper;
use Botble\Shortcode\View\View;
use Botble\Theme\Theme;
use Theme\Eventify\Supports\ThemeHelper;

return [

    /*
    |--------------------------------------------------------------------------
    | Inherit from another theme
    |--------------------------------------------------------------------------
    */

    'inherit' => null, // default

    /*
    |--------------------------------------------------------------------------
    | Listener from events
    |--------------------------------------------------------------------------
    |
    | You can hook a theme when event fired on activities
    | this is cool feature to set up a title, meta, default styles and scripts.
    |
    | [Notice] these events can be overridden by package config.
    |
    */

    'events' => [

        // Before event inherit from package config and the theme that call before,
        // you can use this event to set meta, breadcrumb template or anything
        // you want inheriting.
        'before' => function ($theme): void {
            // You can remove this line anytime.
        },

        // Listen on event before render a theme,
        // this event should call to assign some assets,
        // breadcrumb template.
        'beforeRenderTheme' => function (Theme $theme): void {
            // Partial composer.
            // $theme->partialComposer('header', function($view) {
            //     $view->with('auth', \Auth::user());
            // });

            // You may use this event to set up your assets.

            $theme->asset()->usePath()->add('aos-css', 'libraries/aos/aos.css');
            $theme->asset()->usePath()->add('odometer-css', 'libraries/jquery-odometer/odometer.css');
            $theme->asset()->usePath()->add('magnific-popup-css', 'libraries/magnific-popup/magnific-popup.css');
            $theme->asset()->usePath()->add('nice-select-css', 'libraries/nice-select/nice-select.css');
            $theme->asset()->usePath()->add('owlcarousel-css', 'libraries/owlcarousel/owlcarousel.min.css');
            $theme->asset()->usePath()->add('slick-slider-css', 'libraries/slick-slider/slick-slider.css');

            if (BaseHelper::isRtlEnabled()) {
                $theme->asset()->usePath()->add('bootstrap-css', 'libraries/bootstrap/bootstrap.rtl.min.css');
            } else {
                $theme->asset()->usePath()->add('bootstrap-css', 'libraries/bootstrap/bootstrap.min.css');
            }

            $theme->asset()->usePath()->add('mobile-css', 'css/mobile.css');
            $theme->asset()->usePath()->add('style', 'css/style.css');

            $theme->asset()->container('footer')->usePath()->add('jquery', 'libraries/jquery.min.js');
            $theme->asset()->container('footer')->usePath()->add('bootstrap-js', 'libraries/bootstrap/bootstrap.bundle.min.js');

            $theme->asset()->container('footer')->usePath()->add('aos-js', 'libraries/aos/aos.js');
            $theme->asset()->container('footer')->usePath()->add('counter-js', 'libraries/counter/counter.js');
            $theme->asset()->container('footer')->usePath()->add('gsap-js', 'libraries/gsap/gsap.min.js');
            $theme->asset()->container('footer')->usePath()->add('jquery-appear-js', 'libraries/jquery-appear/jquery.appear.js');
            $theme->asset()->container('footer')->usePath()->add('jquery-odometer-js', 'libraries/jquery-odometer/jquery.odometer.min.js');
            $theme->asset()->container('footer')->usePath()->add('magnific-popup-js', 'libraries/magnific-popup/magnific-popup.js');
            $theme->asset()->container('footer')->usePath()->add('nice-select-js', 'libraries/nice-select/nice-select.js');
            $theme->asset()->container('footer')->usePath()->add('owlcarousel-js', 'libraries/owlcarousel/owlcarousel.min.js');
            $theme->asset()->container('footer')->usePath()->add('slick-slider-js', 'libraries/slick-slider/slick-slider.js');
            $theme->asset()->container('footer')->usePath()->add('waypoints-js', 'libraries/waypoints/waypoints.js');
            $theme->asset()->container('footer')->usePath()->add('scroll-trigger-js', 'js/ScrollTrigger.min.js');

            if (ThemeHelper::isSupportSplitText()) {
                $theme->asset()->container('footer')->usePath()->add('split-text-js', 'js/Splitetext.js');
            }

            $theme->asset()->container('footer')->usePath()->add('sidebar-js', 'js/sidebar.js');
            $theme->asset()->container('footer')->usePath()->add('mobilemenu-js', 'js/mobilemenu.js');
            $theme->asset()->container('footer')->usePath()->add('script', 'js/script.js');
            $theme->asset()->container('footer')->usePath()->add('custom', 'js/custom.js');

            $theme->addBodyAttributes(['class' => 'homepage1-body']);

            if (is_plugin_active('announcement') && Announcement::query()->available()->exists()) {
                $theme->addBodyAttributes(['data-bb-toggle' => 'announcement',  'data-bb-target' => '.mobile-header']);
            }

            if (function_exists('shortcode')) {
                $theme->composer(['page', 'post'], function (View $view) {
                    $view->withShortcodes();
                });
            }
        },

        // Listen on event before render a layout,
        // this should call to assign style, script for a layout.
        'beforeRenderLayout' => [
            'default' => function ($theme): void {
                // $theme->asset()->usePath()->add('ipad', 'css/layouts/ipad.css');
            },
        ],
    ],
];
