@php
    $postMetaData = json_decode(theme_option('blog_post_detail_meta_display', []), true);
    $shouldDisplayDateTime = in_array('published_date', $postMetaData);
    $shouldDisplayAuthor = in_array('author_name', $postMetaData);
    $shouldDisplayView = in_array('view_count', $postMetaData);
    $shouldDisplayReadingTime = in_array('reading_time', $postMetaData);
    $shouldDisplayCategory = in_array('category', $postMetaData);
@endphp
<ul class="post-detail-meta">
    @if (($publishedDate = $post->created_at) && $shouldDisplayDateTime)
        @php
            $formatDate = new DateTime($publishedDate);
        @endphp
        <li>
            <span>
                @if (theme_option('author_icon_image', ''))
                    {{ RvMedia::image(theme_option('calender_icon_image', '')) }}
                @endif
                {{ $formatDate->format('d M Y') }} <span class="symbol-slash"> | </span>
            </span>
        </li>
    @endif
    @if (($author = $post->author) && $shouldDisplayAuthor)
        @php
            $fullName = $author->first_name . ' ' . $author->last_name;
        @endphp
        <li>
            <a href="javascript:void(0)">
                @if (theme_option('author_icon_image', ''))
                    {{ RvMedia::image(theme_option('author_icon_image', '')) }}
                @endif
                {{ $fullName }}
                <span class="symbol-slash"> | </span>
            </a>
        </li>
    @endif
    @if (($views = $post->views) && $shouldDisplayView)
        <li>
            <span>
                @if (theme_option('views_icon_image', ''))
                    {{ RvMedia::image(theme_option('views_icon_image', '')) }}
                @endif
                {{ $views }}
                <span class="symbol-slash"> | </span>
            </span>
        </li>
    @endif
    @if (($readingTime = $post->timeReading) && $readingTime > 0 && $shouldDisplayReadingTime)
        <li>
            <span>
                @if (theme_option('reading_time_icon_image', ''))
                    {{ RvMedia::image(theme_option('reading_time_icon_image', '')) }}
                @endif
                {{ $readingTime == 1 ? __('1 minute read') : __(':count minutes read', ['count' => $readingTime]) }}
                <span class="symbol-slash"> | </span>
            </span>
        </li>
    @endif
    @if (($categories = $post->categories) && $shouldDisplayCategory)
        <li>
            <span>
                @if (theme_option('category_icon_image', ''))
                    {{ RvMedia::image(theme_option('category_icon_image', '')) }}
                @endif
                @foreach ($categories as $category)
                    <a
                        href="{{ $category->url }}"
                        class="mx-0 px-0"
                        title="{{ $category->name }}"
                    >
                        {{ $category->name }}
                    </a>
                    @if (!$loop->last)
                        ,
                    @endif
                @endforeach
            </span>
        </li>
    @endif
</ul>
