@php
    $logo = $logo ?? theme_option('logo');
    if(!$logo){
        $logo = Theme::asset()->url('images/header-logo.png');
    }
    $height = theme_option('logo_height', 25);
    $attributes = [
        'style' => sprintf('height: %s', is_numeric($height) ? "{$height}px" : $height),
        'loading' => false,
    ];

    $wrapperClass ??= null;
@endphp

@if ($logo)
    <div @class(['site-logo', $wrapperClass])>
        @php
            $siteTitle = theme_option('site_title');
        @endphp

        <a class="d-flex" href="{{ BaseHelper::getHomepageUrl() }}">
            {{ RvMedia::image($logo, $siteTitle, attributes: [...$attributes]) }}
        </a>
    </div>
@endif
