@if ($paginator->hasPages())
<div class="pagination-area">
    <nav aria-label="Page navigation example">
        <ul class="pagination">
            <li class="page-item">
                <a class="page-link {{ $paginator->onFirstPage() ? 'disabled' : '' }}" href="{{ $paginator->previousPageUrl() }}" aria-label="Previous">
                    <x-core::icon name="ti ti-chevron-left"/>
                </a>
            </li>
            @foreach ($elements as $element)
                @if (is_string($element))
                    <li>
                        <a class="page-dotted disabled" href="#" aria-disabled="true">...</a>
                    </li>
                @endif

                @if (is_array($element))
                    @foreach ($element as $page => $url)
                        @if ($page == $paginator->currentPage())
                            <li class="page-item">
                                <a class="page-link active" href="#" aria-current="page">{{ $page }}</a>
                            </li>
                        @else
                            <li class="page-item">
                                <a class="page-link" href="{{ $url }}">{{ $page }}</a>
                            </li>
                        @endif
                    @endforeach
                @endif
            @endforeach
            <li class="page-item">
                <a class="page-link {{ $paginator->onLastPage() ? 'disabled' : '' }}" href="#" aria-label="Next">
                    <x-core::icon name="ti ti-chevron-right"/>
                </a>
            </li>

        </ul>
    </nav>
</div>
@endif
