<div
    class="contact2-section-area sp1 shortcode-contact-information shortcode-contact-information-style-2"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 m-auto">
                <div class="contact-header heading4 text-center space-margin60">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>{!! BaseHelper::clean($subtitle) !!}</h5>
                        <div class="space18"></div>
                    @endif
                    @if ($title = $shortcode->title)
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>
        <div class="row align-items-center">
            @if ($address = $shortcode->address)
                <div
                    class="col-lg-7"
                    data-aos="zoom-in"
                    data-aos-duration="1000"
                >
                    <div class="mapouter">
                        <div class="gmap_canvas">
                            <iframe
                                title="{{ $address }}"
                                src="https://maps.google.com/maps?q={{ addslashes($address) }}&t=&z=13&ie=UTF8&iwloc=&output=embed"
                                width="600"
                                height="650"
                                style="border: 0"
                                allowfullscreen=""
                                loading="lazy"
                                referrerpolicy="no-referrer-when-downgrade"
                            ></iframe>
                        </div>
                    </div>
                </div>
            @endif
            <div class="col-lg-5">
                <div
                    class="contact-boxs-area"
                    data-aos="zoom-in"
                    data-aos-duration="1000"
                >
                    @foreach ($contactMethod as $key => $method)
                        @continue(!($title = Arr::get($method, 'title')))
                        <div class="contact-auhtor-box">
                            <div class="icons">
                                @if ($iconImage = Arr::get($method, 'icon_image'))
                                    {{ RvMedia::image($iconImage, 'icon') }}
                                @endif
                            </div>
                            <div class="text">
                                <h4>{!! BaseHelper::clean($title) !!}</h4>
                                <div class="space14"></div>
                                @if ($description = Arr::get($method, 'description'))
                                    @if ($url = Arr::get($method, 'url'))
                                        <a aria-label="{{ $title }}" href='{{ $url }}'>{!! BaseHelper::clean($description) !!}</a>
                                    @else
                                        <span>{!! BaseHelper::clean($description) !!}</span>
                                    @endif
                                @endif
                            </div>
                        </div>
                        @if (!$loop->last)
                            <div class="space30"></div>
                        @endif
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
