<div
    class="contact8-bg-section shortcode-contact-information shortcode-contact-information-style-4" @style($variablesStyle)>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="space48"></div>
                <div class="row">
                    @foreach ($contactMethod as $key => $method)
                        @continue(!($title = Arr::get($method, 'title')))
                        <div class="col-lg-6 col-md-6">
                            <div class="contact-boxarea" data-aos="zoom-in"
                                 data-aos-duration="{{ 900 + ($loop->index * 100) }}">
                                @if ($iconImage = Arr::get($method, 'icon_image'))
                                    <div class="icons">
                                        {{ RvMedia::image($iconImage, 'icon') }}
                                    </div>
                                @endif
                                <div class="text">
                                    <h5>{!! BaseHelper::clean($title) !!}</h5>
                                    @if ($description = Arr::get($method, 'description'))
                                        <div class="space14"></div>
                                        @if ($url = Arr::get($method, 'url'))
                                            <a aria-label="{{ $title }}" href='{{ $url }}'>{!! BaseHelper::clean($description) !!}</a>
                                        @else
                                            <span>{!! BaseHelper::clean($description) !!}</span>
                                        @endif
                                    @endif
                                </div>
                            </div>
                            <div class="space18"></div>
                        </div>
                    @endforeach
                </div>
                <div class="space48"></div>
            </div>
        </div>
    </div>
    @if ($address = $shortcode->address)
        <div class="mapouter">
            <div class="gmap_canvas">
                <iframe
                    title="{{ $address }}"
                    src="https://maps.google.com/maps?q={{ addslashes($address) }}&t=&z=13&ie=UTF8&iwloc=&output=embed"
                    width="600" height="450" style="border: 0" allowfullscreen="" loading="lazy"
                    referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>
        </div>
    @endif
</div>
