<div
    class="shortcode-events-style2 memory2-section-area sp1"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="memory-heaer2 heading4 space-margin60">
                    <div class="heading4">
                        @if ($subtitle = $shortcode->subtitle)
                            <h5>{!! BaseHelper::clean($subtitle) !!}</h5>
                            <div class="space18"></div>
                        @endif

                        @if ($title = $shortcode->title)
                            <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                        @endif
                    </div>

                    @if ($redirectUrl = $shortcode->redirect_url)
                        <div
                            class="btn-area1"
                            data-aos="zoom-in"
                            data-aos-duration="1000"
                        >
                            <a
                                aria-label="redirect"
                                href="{{ $redirectUrl }}"
                                class="vl-btn2"
                                target="blank"
                            ><span class="demo">{{ __('See Recent Photos') }}</span><span class="arrow">
                                    <x-core::icon name="ti ti-arrow-right"/>
                                </span></a>
                        </div>
                    @endif
                </div>
            </div>
            <div class="col-lg-12">
                <div class="memory-widget-slider owl-carousel">
                    @foreach ($events as $event)
                        <div class="memory-widget-boxarea">
                            <div class="img1">
                                {{ RvMedia::image($event->image, $event->name, 'medium-rectangle-vertical') }}
                            </div>
                            <div class="content-area">
                                @if ($url = $event->url)
                                    <a aria-label="{{ $event->url }}" href="{{ $event->url }}" class="arrow"><x-core::icon name="ti ti-arrow-right"/></a>
                                @else
                                    <span class="arrow"><x-core::icon name="ti ti-arrow-right"/></span>
                                @endif
                                <div class="text">
                                    <p>{{ __('Event :year', ['year' => $event->started_at?->format('Y')]) }}</p>
                                    <div class="space12"></div>
                                    <a aria-label="{{ $event->name }}" href="{{ $event->url }}">{{ $event->name }}</a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
