<div class="memory4-section-area sp1 shortcode-events shortcode-events-style-4" @style($variablesStyle)>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="memory4-header heading6 space-margin60">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5
                            data-aos="fade-left"
                            data-aos-duration="800"
                        >{!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif
                    <div class="space18"></div>
                    @if ($title = $shortcode->title)
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
            <div class="col-lg-3"></div>
            <div class="col-lg-3">
                <div class="btn-area1">
                    @if ($url = $shortcode->redirect_url)
                        <a aria-label="{{ __('See Recent Photos') }}" href="{{ $url }}" class="vl-btn4">{{ __('See Recent Photos') }}</a>
                    @else
                        <span class="vl-btn4">{{ __('See Recent Photos') }}</span>
                    @endif
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="memory-team-slider2 owl-carousel">
                    @foreach ($events as $event)
                        <div class="memory3-boxarea">
                            <div class="img1">
                                {{ RvMedia::image($event->image, $event->name, 'medium-rectangle-vertical') }}
                            </div>
                            <div class="content-area">
                                @if ($startedAt = $event->started_at)
                                    <p>{{ __('Event :year', ['year' => $startedAt->format('Y')]) }}</p>
                                @endif
                                <div class="space12"></div>
                                <a aria-label="{{ $event->name }}" href="{{ $event->url }}">{{ $event->name }}</a>
                                <div class="plus">
                                    <a aria-label="{{ $event->name }}" href="{{ $event->url }}"><x-core::icon name="ti ti-plus"/></a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
