<div class="hero8-slider-area shortcode-hero-banner shortcode-hero-banner-style-7" @style($variablesStyle)>
    <img src="{{ Theme::asset()->url('images/backgrounds/layer1.png') }}" alt="" class="layer1" />
    <div class="container">
        <div class="row">
            <div class="col-lg-8 m-auto">
                <div class="hero8-header text-center">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>
                            @if($subtitleImage = $shortcode->subtitle_image)
                                {{ RvMedia::image($subtitleImage, '', 'thumbnail', attributes: ['class' => 'd-md-inline-block d-none']) }}
                            @endif

                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space32"></div>
                        <h1 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h1>
                    @endif


                    @if (($buttonLabel = $shortcode->button_primary_label) && ($buttonUrl = $shortcode->button_primary_url))
                        <div class="space40"></div>
                        <div class="btn-area1">
                            <a href="{{ $buttonUrl }}" class="vl-btn8">
                                <span class="demo">{!! BaseHelper::clean($buttonLabel) !!}</span>
                                <span class="arrow"><x-core::icon name="ti ti-arrow-right"/></span>
                            </a>
                        </div>

                    @endif
                </div>
            </div>
        </div>
    </div>
    @if($circleText = $shortcode->circle_text)
        <div class="arrow-btnarea">
            <a href="">
                <div class="content" bis_skin_checked="1">
                    <h6 class="circle rotateme">{!! BaseHelper::clean($circleText) !!}</h6>
                </div>
                <img src="{{ Theme::asset()->url('images/icons/arrow1.svg') }}" alt="" class="arrow1" />
            </a>
        </div>
    @endif

    @if ($event)
        <div class="date-btn aniamtion-key-1">
            <h4>{{ $event->started_at?->format('d') }}</h4>
            <div class="space14"></div>
            <p>{{ $event->started_at?->format('M') }}</p>
            <div class="space20"></div>
            <a href="{{ $event->url }}">{{ __('Buy Ticket') }}</a>
        </div>
    @endif
</div>
