@if($event)
    @php
        $startedAt = $event->started_at;
        $endedAt = $event->ended_at;

        // Parse dates into DateTime objects
        $startDateTime = new DateTime($startedAt);
        $endDateTime = new DateTime($endedAt);

        // Format the dates
        $startFormatted = $startDateTime->format("jS");
        $endFormatted = $endDateTime->format("jS");

        // Calculate the month
        $month = $startDateTime->format("F");
        $year = $startDateTime->format("Y");

        // Construct the final text
        $event_time = "{$startFormatted}, {$endFormatted} {$month} “{$year}”'";
    @endphp
    <div class="hero10-section-area" @style($variablesStyle)>
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-7">
                    <div class="hero6-header">
                        @if($subtitle = $shortcode->subtitle)
                            <h5>
                                @if($subtitle_image = $shortcode->subtitle_image)
                                    {{ RvMedia::image($subtitle_image, '', attributes: ['class' => 'd-md-inline-block d-none', 'width' => 30, 'height' => 30]) }}
                                @endif

                                {!! BaseHelper::clean($subtitle) !!}
                            </h5>
                        @endif

                        @if ($name = $event->name)
                            <div class="space24"></div>
                            <h1 class="text-anime-style-3">{!! BaseHelper::clean($name) !!}</h1>
                        @endif

                        @if($short_description = $event->short_description)
                            <div class="space32"></div>
                            <p>
                                {!! BaseHelper::clean($short_description) !!}
                            </p>
                        @endif

                        @if($startedAt && $endedAt)
                            <div class="space16"></div>
                            <ul>
                                <li>
                                    <a href="#">
                                        <img src="{{ Theme::asset()->url('images/icons/calender.svg') }}" alt="" />
                                        {{ $event_time }}
                                    </a>
                                </li>
                            </ul>
                        @endif

                        @if($button_primary_label = $shortcode->button_primary_label)
                            <div class="space32"></div>
                            <div class="btn-area1">
                                <a href="{{ $event->url }}" class="vl-btn10">
                                    {{ $button_primary_label }}
                                    <img src="{{ Theme::asset()->url('images/icons/arrow2.svg') }}" alt="" />
                                </a>
                            </div>
                        @endif

                        @if($circleText = $shortcode->circle_text)
                            <div class="arrow-btn">
                                <div class="content" bis_skin_checked="1">
                                    <h6 class="circle rotateme">{{ $circleText }}</h6>
                                </div>
                                <div class="arrow">
                                    <img src="{{ Theme::asset()->url('images/icons/arrow3.svg') }}" alt="" />
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="hero10-images">
                        @if($image = $event->image)
                            <div class="img1">
                                {{ RvMedia::image($image, $event->name) }}
                            </div>
                        @endif

                        @php $counter = 2; @endphp
                        @foreach($tabs as $key => $tab)
                            @continue(! $image = Arr::get($tab, 'image'))

                            <div class="img{{ $counter }}">
                                {{ RvMedia::image($image, '', 'thumbnail') }}
                            </div>
                            @php $counter++; @endphp
                        @endforeach

                        <img src="{{ Theme::asset()->url('images/icons/elements38.png') }}" alt="" class="elements38 keyframe5" />
                    </div>
                </div>
            </div>
        </div>
    </div>

@endif
