@php
    $image = $shortcode->separator_image;

    $bgColor = $shortcode->background_color;
    $textColor = $shortcode->text_color;
    $bgImage = $shortcode->background_image ? RvMedia::getImageUrl($shortcode->background_image) : null;

    $variablesStyle = [];

    if ($textColor && $textColor !== 'transparent') {
        $variablesStyle["--shortcode-text-color: $textColor"] = $textColor;
    }
    if ($bgColor !== 'transparent') {
        $variablesStyle["--shortcode-background-color: $bgColor"] = $bgColor;
    }
    if ($bgImage) {
        $variablesStyle["--shortcode-background-image: url($bgImage)"] = $bgImage;
    }
@endphp

<div class="shortcode-marquees brands5-section-area"
    @style($variablesStyle)
>
    <div class="marquee-container">
        <div class="marquee-content">
            @foreach($tabs as $item)
                @continue(! $name = Arr::get($item, 'name'))
                <div>
                    <span class="marquee-item">
                        @if($image)
                            {{ RvMedia::image($image, '') }}
                        @else
                            <img src="{{ Theme::asset()->url('images/shapes/elements32.png') }}" alt="" />
                        @endif

                        {!! BaseHelper::clean($name) !!}
                    </span>
                </div>
            @endforeach
        </div>
    </div>
</div>
