<div class="pricing-plan-section-area sp2 shortcode-pricing shortcode-pricing-style-2"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row">
            <div class="col-lg-5 m-auto">
                <div class="pricingplan heading4 text-center space-margin60">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>{!! BaseHelper::clean($subtitle) !!}</h5>
                        <div class="space18"></div>
                    @endif


                    @if ($title = $shortcode->title)
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>
        @if (count($tabs) > 0)
            @php
                $durations = [800, 1000, 1200];
            @endphp

            <div class="row">
                @foreach ($tabs as $tab)
                    @continue(! ($name = Arr::get($tab, 'name')))
                    <div class="col-lg-4 col-md-6" data-aos="fade-up" data-aos-duration="{{  $durations[$loop->index] }}">
                        <div @class(['pricing-boxarea', 'box2' => Arr::get($tab, 'is_featured') === 'yes'])>
                            <div class="ticket-box">
                                <p>{!! BaseHelper::clean($name) !!}</p>
                                @if ($price = Arr::get($tab, 'price'))
                                    <div class="space16"></div>
                                    <h3>{!! BaseHelper::clean($price) !!}</h3>
                                @endif

                                @if (($maxPoint = Arr::get($tab, 'max_point')) && ($currentPoint = Arr::get($tab, 'point')))
                                    <div class="space24"></div>
                                    <div class="progress">
                                        <div class="progress-inner" style="width: {{ $currentPoint/$maxPoint * 100 }}%"></div>
                                    </div>
                                    <div class="space14"></div>
                                    <p>{{ $currentPoint }}/{{  $maxPoint }}</p>
                                @endif

                                @if (($buttonUrl = Arr::get($tab, 'button_url')) && ($buttonLabel = Arr::get($tab, 'button_label')))
                                    <div class="space24"></div>
                                    <div class="btn-area1">
                                        <a href="{{  $buttonUrl }}" class="vl-btn2">
                                            <span class="demo">{!! BaseHelper::clean($buttonLabel) !!}</span>
                                            <span class="arrow"><x-core::icon name="ti ti-arrow-right"/></span>
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
    </div>
</div>
