@php
    $bgColor = $shortcode->background_color;
    $bgImage = $shortcode->background_image ? RvMedia::getImageUrl($shortcode->background_image) : null;

    $variablesStyle = [
        "--shortcode-background-color: $bgColor" => $bgColor,
        "--shortcode-background-image: url($bgImage)" => $bgImage,
    ];

    $events = [];
    $eventIds = [];

    if (is_plugin_active('events-booking')) {
        foreach ($sliders as $slider) {
            $eventIds[] = $slider->getMetaData('event_id', true);
        }

        $eventsModel = \Archielite\EventsBooking\Models\Event::query()
            ->where('status', \ArchiElite\EventsBooking\Enums\EventStatusEnum::APPROVED)
            ->where('started_at', '>=', Carbon\Carbon::now())
            ->whereIn('id', array_filter($eventIds))
            ->get();

        foreach ($eventsModel as $event) {
            $events[$event->getKey()] = $event;
        }
    }
@endphp

<div class="hero2-slider-area shortcode-simple-slider"
    @style($variablesStyle)
>
    @foreach($sliders as $slider)
        <div class="her2-section-area">
            <img src="{{ Theme::asset()->url('images/shapes/elements9.png') }}" alt="shape" class="elements9" />
            <img src="{{ Theme::asset()->url('images/shapes/elements10.png') }}" alt="shape" class="elements10" />
            <img src="{{ Theme::asset()->url('images/shapes/elements11.png') }}" alt="shape" class="elements11" />

            @if ($image = $slider->image)
                <div class="img1">
                    {{ RvMedia::image($image, $slider->title) }}
                </div>
            @endif

            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="hero2-header">
                            @if ($subtitle = $slider->getMetaData('subtitle', true))
                                <h5>
                                    {{ RvMedia::image(theme_option('favicon'), theme_option('site_title'), attributes: ['width' => 16, 'height' => 16, 'class' => 'white-image']) }}
                                    {!! BaseHelper::clean($subtitle) !!}
                                </h5>
                            @endif
                            @if ($title = $slider->title)
                                <div class="space28"></div>
                                <h1>{!! BaseHelper::clean($title) !!}</h1>
                            @endif

                            @if ($highlightTitle = $slider->getMetaData('highlight_title', true))
                                <div class="space16"></div>
                                <h1><span class="conferences">{!! BaseHelper::clean($highlightTitle) !!}</h1>
                            @endif

                            @if (is_plugin_active('events-booking') && ($event = Arr::get($events, $slider->getMetaData('event_id', true))))
                                <div class="timer" data-target="{{ $event->started_at }}">
                                    <div class="time-box">
                                        <span class="time-value days"></span>
                                        <div class="space8"></div>
                                    </div>
                                    <div class="space14"></div>
                                    <div class="time-box">
                                        <span class="time-value hours"></span>
                                        <div class="space8"></div>
                                    </div>
                                    <div class="space14"></div>
                                    <div class="time-box">
                                        <span class="time-value minutes"></span>
                                        <div class="space8"></div>
                                    </div>
                                    <div class="space14"></div>
                                    <div class="time-box" style="margin: 0">
                                        <span class="time-value seconds"></span>
                                        <div class="space8"></div>
                                    </div>
                                </div>
                            @endif

                            @if (($buttonLabel = $slider->getMetaData('button_label', true)) && ($buttonUrl = $slider->link))
                                <div class="space32"></div>
                                <div class="btn-area1">
                                    <a href="{{ $buttonUrl }}" class="vl-btn2"
                                    ><span class="demo">{!! BaseHelper::clean($buttonLabel) !!}</span><span
                                            class="arrow"><x-core::icon name="ti ti-arrow-right"/></span
                                        ></a>
                                </div>
                            @endif
                        </div>
                    </div>


                    @if (is_plugin_active('events-booking') && ($event = Arr::get($events, $slider->getMetaData('event_id', true))))
                        <div class="col-lg-3">
                            <div class="arrow-btn">
                                <div class="about-btnarea">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="200" height="200"
                                         viewBox="0 0 200 200" fill="none" class="keyframe5">
                                        <path
                                            d="M93.8771 2.53621C96.8982 1.28483 98.4087 0.659138 100 0.659138C101.591 0.659138 103.102 1.28483 106.123 2.5362L164.588 26.7531C167.609 28.0045 169.119 28.6302 170.245 29.7554C171.37 30.8806 171.995 32.3912 173.247 35.4123L197.464 93.8771C198.715 96.8982 199.341 98.4087 199.341 100C199.341 101.591 198.715 103.102 197.464 106.123L173.247 164.588C171.995 167.609 171.37 169.119 170.245 170.245C169.119 171.37 167.609 171.995 164.588 173.247L106.123 197.464C103.102 198.715 101.591 199.341 100 199.341C98.4087 199.341 96.8982 198.715 93.8771 197.464L35.4123 173.247C32.3912 171.995 30.8806 171.37 29.7554 170.245C28.6302 169.119 28.0045 167.609 26.7531 164.588L2.53621 106.123C1.28483 103.102 0.659138 101.591 0.659138 100C0.659138 98.4087 1.28483 96.8982 2.5362 93.8771L26.7531 35.4123C28.0045 32.3912 28.6302 30.8806 29.7554 29.7554C30.8806 28.6302 32.3912 28.0045 35.4123 26.7531L93.8771 2.53621Z"
                                            fill="#C0F037"
                                        />
                                    </svg>
                                    <a href="{{ $event->url }}">
                                        <span><x-core::icon name="ti ti-arrow-right"/></span>
                                        <br />
                                        <div class="space12"></div>
                                        {{  __('Buy Ticket') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    @endforeach
</div>

