@use(Botble\Theme\Supports\ThemeSupport)

<div class="team2-section-area sp1 shortcode-speakers shortcode-speakers-style-2"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row">
            <div class="col-lg-5 m-auto">
                <div class="team2-header heading4 space-margin60 text-center">
                    @if($subtitle = $shortcode->subtitle)
                        <h5>{!! BaseHelper::clean($subtitle) !!}</h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space18"></div>
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>
        <div class="row">
            @foreach($speakers as $speaker)
                <div class="col-lg-3 col-md-6" data-aos="zoom-in" data-aos-duration="{{ 900 + ($loop->index * 100)  }}">
                    <div class="our-team-boxarea">
                        <div class="team-widget-area">
                            <div class="img1">
                                @if ($avatar = $speaker->avatar)
                                    {{ RvMedia::image($speaker->avatar, $speaker->name ?? '', attributes: ['class' => 'team-img4']) }}
                                @endif
                                <img src="{{ Theme::asset()->url('images/shapes/elements16.png') }}" alt="" class="team-img8" />

                                @if ($socials = $speaker->getMetaData('socials', true))
                                    @php
                                        $socials = ThemeSupport::convertSocialLinksToArray($socials);
                                    @endphp

                                    <ul>
                                        @foreach($socials as $social)
                                            @continue($loop->index > 2)

                                            <li>
                                                <a class="icon{{ $loop->index + 1 }}" title="{{ $social->getName() }}" href="{{ $social->getUrl() }}" target="_blank">
                                                    {!! $social->getIconHtml() !!}
                                                </a>
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                        </div>
                        <div class="space28"></div>
                        <div class="content-area">
                            <a href="{{ $speaker->url }}">{{ $speaker->name }}</a>
                            <div class="space16"></div>
                            @if ($title = $speaker->getMetaData('title', true))
                                <p>{!! BaseHelper::clean($title) !!}</p>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
