<div class="team6-section-area sp2 shortcode-speakers shortcode-speaker-style-6" @style($variablesStyle)>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 m-auto">
                <div class="team-heading heading9 text-center space-margin60">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>
                            @if ($subtitleImage = $shortcode->subtitle_image)
                                {{ RvMedia::image($subtitleImage, 'icon',attributes: ['class' => 'subtitle-img']) }}
                            @endif

                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space20"></div>
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>

        <div class="row">
            @foreach ($speakers as $speaker)
                <div class="col-lg-3 col-md-6" data-aos="fade-up" data-aos-duration="{{ 900 + ($loop->index * 100) }}">
                    <div class="team-widget-area">
                        <div class="img1 image-anime">
                            {{ RvMedia::image($speaker->avatar, $speaker->name, 'medium-rectangle-vertical') }}
                        </div>

                        <div class="content-area">
                            <a href="{{ $speaker->url }}">{{ $speaker->name }}</a>

                            @if ($speakerTitle = $speaker->getMetaData('title', true))
                                <div class="space12"></div>
                                <p>{!! BaseHelper::clean($speakerTitle) !!}</p>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
