@php
    $bgColor = $shortcode->background_color;
    $textColor = $shortcode->text_color;
    $bgImage = $shortcode->background_image ? RvMedia::getImageUrl($shortcode->background_image) : null;

    $variablesStyle = [];

    if ($textColor && $textColor !== 'transparent') {
        $variablesStyle["--shortcode-text-color: $textColor"] = $textColor;
    }
    if ($bgColor !== 'transparent') {
        $variablesStyle["--shortcode-background-color: $bgColor"] = $bgColor;
    }
    if ($bgImage) {
        $variablesStyle["--shortcode-background-image: url($bgImage)"] = $bgImage;
    }
@endphp

<div class="shortcode-tabs-content attent1-section-area sp6"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row">
            <div class="col-lg-11 m-auto">
                <div class="heading8 text-center space-margin80">
                    @if($subtitle = $shortcode->subtitle)
                        <h5>
                            @if ($subtitleImage = $shortcode->subtitle_image)
                                {{ RvMedia::image($subtitleImage, '') }}
                            @endif

                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif

                    @if($title = $shortcode->title)
                        <div class="space32"></div>
                        <h2>{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="tab-container">
                    <div class="row align-items-center">
                        <div class="col-lg-1 ltr"></div>
                        <div class="col-lg-5">
                            <ul class="nav flex-column nav-pills" id="tab-navigation" role="tablist"
                                aria-orientation="vertical">
                                @foreach($tabs as $tab)
                                    @continue(! $tabTitle = Arr::get($tab, 'title'))
                                    <li class="nav-item">
                                        <a @class(['nav-link', 'active link1' => $loop->first]) id="{{ Str::slug($tabTitle) }}-tab"
                                           data-bs-toggle="pill" href="#{{ Str::slug($tabTitle) }}"
                                           role="tab" aria-controls="{{ Str::slug($tabTitle) }}" aria-selected="true">
                                            <svg class="svg1" xmlns="http://www.w3.org/2000/svg" width="29" height="75"
                                                 viewBox="0 0 29 75" fill="none">
                                                <path
                                                    d="M0.946169 36.2765C0.388977 36.997 0.388978 38.003 0.94617 38.7235L29 75L29 0L0.946169 36.2765Z"
                                                    fill="white" fill-opacity="0.2" />
                                            </svg>

                                            <svg class="svg2" xmlns="http://www.w3.org/2000/svg" width="29" height="75"
                                                 viewBox="0 0 29 75" fill="none">
                                                <path
                                                    d="M0.946169 36.2765C0.388977 36.997 0.388978 38.003 0.94617 38.7235L29 75L29 0L0.946169 36.2765Z"
                                                    fill="url(#paint0_linear_2700_2802)" />
                                                <defs>
                                                    <linearGradient id="paint0_linear_2700_2802" x1="0" y1="0"
                                                                    x2="50.4562"
                                                                    y2="19.5097" gradientUnits="userSpaceOnUse">
                                                        <stop stop-color="#FF7A00" />
                                                        <stop offset="1" stop-color="#FF0000" />
                                                    </linearGradient>
                                                </defs>
                                            </svg>
                                            {!! BaseHelper::clean($tabTitle) !!}

                                            @if($tabDescription = Arr::get($tab, 'description'))
                                                <span> {!! BaseHelper::clean($tabDescription) !!} </span>
                                            @endif
                                        </a>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                        <div class="col-lg-1 rtl"></div>
                        <div class="col-lg-6">
                            <div class="tab-content" id="tab-content">
                                @foreach($tabs as $item)
                                    @continue(! $tabTitle = Arr::get($item, 'title'))

                                    <div
                                        @class(['tab-pane fade', 'show active' => $loop->first]) id="{{ Str::slug($tabTitle) }}"
                                        role="tabpanel"
                                        aria-labelledby="{{ Str::slug($tabTitle) }}-tab">
                                        <div class="about3-images">
                                            @if($image3 = Arr::get($item, 'image_3'))
                                                {{ RvMedia::image($image3, '', attributes: ['class' => 'about-img10 aniamtion-key-1']) }}
                                            @endif

                                            @if ($image = Arr::get($item, 'image'))
                                                <div class="img1" data-aos="zoom-in" data-aos-duration="1000">
                                                    {{ RvMedia::image($image, '') }}
                                                </div>
                                            @endif

                                            @if($image1 = Arr::get($item, 'image_1'))
                                                <div class="img2" data-aos="zoom-in" data-aos-duration="1100">
                                                    {{ RvMedia::image($image1, '') }}
                                                </div>
                                            @endif

                                            @if($image2 = Arr::get($item, 'image_2'))
                                                <div class="img3" data-aos="zoom-in" data-aos-duration="1200">
                                                    {{ RvMedia::image($image2, '') }}
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
