@php
    $route ??= 'account.invoices.generate-invoice';
    $event = $order->event;
    $tickets = $order->tickets;
    $order->loadMissing('payment', 'invoice');
@endphp

<div class="container">
    <div class="container mt-5">
        <div class="card p-4 shadow-sm booking-information">
            <h2 class="title text-anime-style-3 mb-5">{{ __('Your booking information') }}</h2>
            <div class="row mb-4">
                <div class="col-md-3 mb-3">
                    <p class="mb-1 attribute-title"><strong>{{ __('Time') }}</strong></p>
                    <p class="attribute-value">{{ $order->created_at }}</p>
                </div>
                <div class="col-md-3 mb-3">
                    <p class="mb-1 attribute-title"><strong>{{ __('Full Name') }}</strong></p>
                    <p class="attribute-value">{{ $order->account_name }}</p>
                </div>

                @if ($email = $order->account_email)
                    <div class="col-md-3 mb-3">
                        <p class="mb-1 attribute-title"><strong>{{ __('Email') }}</strong></p>
                        <p class="attribute-value">{{ $email }}</p>
                    </div>
                @endif

                @if ($event)
                    <div class="col-md-3 mb-3">
                        <p class="mb-1 attribute-title"><strong>{{ __('Event') }}</strong></p>
                        <a
                            href="{{ $event->url }}"
                            class="attribute-value underline"
                        >{{ $event->name }}</a>
                    </div>
                @endif

                <div class="col-md-3 mb-3">
                    <p class="mb-1 attribute-title"><strong>{{ __('Start Date') }}</strong></p>
                    <p class="attribute-value">{{ $event->started_at }}</p>
                </div>

                @if ($endedAt = $event->ended_at)
                    <div class="col-md-3 mb-3">
                        <p class="mb-1 attribute-title"><strong>{{ __('End Date') }}</strong></p>
                        <p class="attribute-value">{{ $endedAt }}</p>
                    </div>
                @endif

                <div class="col-md-3 mb-3">
                    <p class="mb-1 attribute-title"><strong>{{ __('Order Status') }}</strong></p>
                    <p class="attribute-value">{!! $order->status->toHtml() !!}</p>
                </div>
            </div>

            @if ($tickets->isNotEmpty())
                <div
                    class="row mb-4"
                    style="overflow-x: auto; !important"
                >
                    <h4 class="title text-anime-style-3">{{ __('Tickets') }}</h4>
                    <x-core::table>
                        <x-core::table.header>
                            <x-core::table.header.cell>
                                {{ __('#') }}
                            </x-core::table.header.cell>

                            @if ($order->status->getValue() == 'completed')
                                <x-core::table.header.cell style="width: 100px; !important">
                                    {{ __('QR Code') }}
                                </x-core::table.header.cell>

                                <x-core::table.header.cell>
                                    {{ __('Code') }}
                                </x-core::table.header.cell>
                            @endif

                            <x-core::table.header.cell>
                                {{ __('Name') }}
                            </x-core::table.header.cell>
                            <x-core::table.header.cell>
                                {{ __('Email') }}
                            </x-core::table.header.cell>
                            <x-core::table.header.cell>
                                {{ __('Status') }}
                            </x-core::table.header.cell>
                        </x-core::table.header>
                        <x-core::table.body>
                            @foreach ($tickets as $ticket)
                                <x-core::table.body.row>
                                    <x-core::table.body.cell>
                                        {{ $loop->index + 1 }}
                                    </x-core::table.body.cell>
                                    @if ($order->status->getValue() == 'completed')
                                        <x-core::table.body.cell>
                                            <img
                                                src="{{ $ticket->qr_code_image }}"
                                                alt=""
                                                style="width: 100px;!important; height: 100px!important; max-height: unset;!important; max-width: unset;!important; "
                                            >
                                        </x-core::table.body.cell>

                                        <x-core::table.body.cell>
                                            {{ $ticket->code }}
                                        </x-core::table.body.cell>
                                    @endif
                                    <x-core::table.body.cell>
                                        {{ $ticket->name }}
                                    </x-core::table.body.cell>
                                    <x-core::table.body.cell>
                                        {{ $ticket->email }}
                                    </x-core::table.body.cell>
                                    <x-core::table.body.cell>
                                        {{ $ticket->status->toHtml() }}
                                    </x-core::table.body.cell>
                                </x-core::table.body.row>
                            @endforeach
                        </x-core::table.body>
                    </x-core::table>
                </div>
            @endif

            <div class="row">
                <div class="col-md-3 mb-3">
                    <p class="mb-1 attribute-title"><strong>{{ __('Sub total') }}</strong></p>
                    <p class="attribute-value">{{ format_price($order->subtotal) }}</p>
                </div>

                @if (($couponCode = $order->coupon_code) && ($couponAmount = $order->coupon_amount))
                    <div class="col-md-3 mb-3">
                        <p class="mb-1 attribute-title"><strong>{{ __('Discount') }}</strong></p>
                        <p class="attribute-value">{{ format_price($couponAmount) }} ({{ $couponCode }})</p>
                    </div>
                @endif

                <div class="col-md-3 mb-3">
                    <p class="mb-1 attribute-title"><strong>{{ __('Tax amount') }}</strong></p>
                    <p class="attribute-value">{{ format_price($order->tax_amount) }}</p>
                </div>

                <div class="col-md-3 mb-3">
                    <p class="mb-1 attribute-title"><strong>{{ __('Total') }}</strong></p>
                    <p class="attribute-value">{{ format_price($order->total) }}</p>
                </div>

                @if (is_plugin_active('payment') && $order->payment->id)
                    @auth
                        <div class="col-md-3 mb-3">
                            <p class="mb-1 attribute-title"><strong>{{ __('Payment ID') }}</strong></p>
                            <a
                                href="{{ route('payment.show', $order->payment->id) }}"
                                target="_blank"
                            >
                                {{ $order->payment->charge_id }}
                                <i class="fas fa-external-link-alt"></i>
                            </a>
                        </div>
                    @endauth

                    <div class="col-md-3 mb-3">
                        <p class="mb-1 attribute-title"><strong>{{ __('Payment method') }}</strong></p>
                        <p class="attribute-value">{{ $order->payment->payment_channel->label() }}</p>
                    </div>

                    <div class="col-md-3 mb-3">
                        <p class="mb-1 attribute-title"><strong>{{ __('Payment status') }}</strong></p>
                        <p class="attribute-value">{!! $order->payment->status->toHtml() !!}</p>
                    </div>

                    @if (
                        $order->payment->payment_channel == \Botble\Payment\Enums\PaymentMethodEnum::BANK_TRANSFER &&
                            $order->payment->status == \Botble\Payment\Enums\PaymentStatusEnum::PENDING)
                        <div class="col-md-3 mb-3">
                            <p class="mb-1 attribute-title"><strong>{{ __('Payment info') }}</strong></p>
                            <p class="attribute-value">{!! BaseHelper::clean(get_payment_setting('description', $order->payment->payment_channel)) !!}</p>
                        </div>
                    @endif
                @endif
            </div>

            @if ((auth('account')->check() && $order->account_id) && ($invoiceId = $order?->invoice?->id) && $route)
                @php
                    $buttonClass = 'btn vl-btn1 border-0';
                @endphp
                <div class="btn-list d-flex flex-wrap gap-2 mt-5">
                    <x-core::button
                        tag="a"
                        :href="route($route, ['invoice' => $invoiceId, 'type' => 'print'])"
                        target="_blank"
                        icon="ti ti-printer"
                        :class="$buttonClass ?? ''"
                    >
                        {{ __('Print Invoice') }}
                    </x-core::button>
                    <x-core::button
                        tag="a"
                        :href="route($route, ['invoice' => $invoiceId, 'type' => 'download'])"
                        target="_blank"
                        icon="ti ti-download"
                        :class="$buttonClass ?? ''"
                    >
                        {{ __('Download Invoice') }}
                    </x-core::button>
                </div>
            @endif
        </div>
    </div>
</div>
