@php
    Theme::set('pageTitle', $event->name);

    if ($coverImage = $event->getMetaData('cover_image', true)) {
        Theme::set('breadcrumb_background_image', $coverImage);
    }
@endphp

{!! apply_filters('ads_render', null, 'event_before', ['class' => 'mb-2']) !!}

<div class="event-sidepage-section-area sp8 event-detail">
    <div class="container">
        <div class="row">
            <div class="col-lg-7">
                <div class="event-side-images">
                    <div class="img1">
                        {{ RvMedia::image($event->image, $event->name, 'large') }}
                    </div>
                    <div class="space32"></div>
                    <h3>{{ $event->name }}</h3>

                    @if ($content = $event->content)
                        <div class="space16"></div>
                        <div class="ck-content">
                            {!! BaseHelper::clean($content) !!}
                        </div>
                    @endif

                    @if ($speakers = $event->speakers)
                        <div class="space40"></div>
                        <h4>{{ __('Event Speakers') }}</h4>
                        {!! Theme::partial('event-booking.speakers', compact('speakers')) !!}
                    @endif
                </div>
            </div>
            <div class="col-lg-5">
                {!! Theme::partial('event-booking.event-sidebar', compact('event')) !!}
            </div>
        </div>
    </div>
</div>

{!! apply_filters('ads_render', null, 'event_after', ['class' => 'mt-2']) !!}

{!! dynamic_sidebar('event_list_sidebar') !!}
