{!! apply_filters('ads_render', null, 'post_list_before', ['class' => 'mb-2']) !!}

<div class="bloginner-section-area sp1 blog-list-page">
    <div class="container">
        <div class="row">
            @forelse($posts as $key => $post)
                {!! Theme::partial(
                    'blogs.post',
                    compact('key', 'post'),
                ) !!}
            @empty
                <div class="text-center">
                    <h5>{{ __('No posts found.') }}</h5>
                </div>
            @endforelse

            @if ($posts instanceof \Illuminate\Contracts\Pagination\LengthAwarePaginator && $posts->total() > 0)
                <div class="space30"></div>
                {{ $posts->withQueryString()->links(Theme::getThemeNamespace('partials.pagination')) }}
            @endif
        </div>
    </div>
</div>

{!! apply_filters('ads_render', null, 'post_list_after', ['class' => 'mt-2']) !!}
