<?php

use Botble\Base\Forms\FieldOptions\ColorFieldOption;
use Botble\Base\Forms\FieldOptions\DescriptionFieldOption;
use Botble\Base\Forms\FieldOptions\MediaImageFieldOption;
use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\Fields\ColorField;
use Botble\Base\Forms\Fields\MediaImageField;
use Botble\Base\Forms\Fields\TextareaField;
use Botble\Base\Forms\Fields\TextField;
use Botble\Widget\AbstractWidget;
use Botble\Widget\Forms\WidgetForm;

class ActionBlockWidget extends AbstractWidget
{
    public function __construct()
    {
        parent::__construct([
            'name' => __('Action Block'),
            'description' => __('Widget action block'),
        ]);
    }

    public function settingForm(): string|null|WidgetForm
    {
        return WidgetForm::createFromArray($this->getConfig())
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add('description', TextareaField::class, DescriptionFieldOption::make())
            ->add('button_label', TextField::class, TextFieldOption::make()->label(__('Button Label')))
            ->add('button_url', TextField::class, TextFieldOption::make()->label(__('Button URL')))
            ->add('background_color', ColorField::class, ColorFieldOption::make()->label(__('Background Color')))
            ->add('background_image', MediaImageField::class, MediaImageFieldOption::make()->label(__('Background Image')));
    }
}
